/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.packetevents.protocol.dialog.action;

import dev.onelili.unichat.lib.packetevents.protocol.chat.clickevent.ClickEvent;
import dev.onelili.unichat.lib.packetevents.protocol.chat.clickevent.ClickEventAction;
import dev.onelili.unichat.lib.packetevents.protocol.chat.clickevent.ClickEventActions;
import dev.onelili.unichat.lib.packetevents.protocol.dialog.action.Action;
import dev.onelili.unichat.lib.packetevents.protocol.dialog.action.ActionType;
import dev.onelili.unichat.lib.packetevents.protocol.dialog.action.ActionTypes;
import dev.onelili.unichat.lib.packetevents.protocol.nbt.NBTCompound;
import dev.onelili.unichat.lib.packetevents.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class StaticAction
implements Action {
    private final ActionType<?> actionType;
    private final ClickEvent clickEvent;

    public StaticAction(ClickEvent clickEvent) {
        if (!clickEvent.getAction().isAllowFromServer()) {
            throw new IllegalArgumentException("Can't create action for unreadable click event with action " + clickEvent.getAction());
        }
        this.actionType = (ActionType)ActionTypes.getRegistry().getByNameOrThrow(clickEvent.getAction().getName());
        this.clickEvent = clickEvent;
    }

    public static StaticAction decode(NBTCompound compound, PacketWrapper<?> wrapper) {
        String actionName = compound.getStringTagValueOrThrow("type");
        ClickEventAction action = (ClickEventAction)ClickEventActions.getRegistry().getByNameOrThrow(actionName);
        Object clickEvent = action.decode(compound, wrapper);
        return new StaticAction((ClickEvent)clickEvent);
    }

    public static void encode(NBTCompound compound, PacketWrapper<?> wrapper, StaticAction action) {
        action.clickEvent.getAction().encode(compound, wrapper, action.clickEvent);
    }

    @Override
    public ActionType<?> getType() {
        return this.actionType;
    }

    public ClickEvent getClickEvent() {
        return this.clickEvent;
    }
}

