/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.packetevents.protocol.dialog.button;

import dev.onelili.unichat.lib.packetevents.protocol.dialog.action.Action;
import dev.onelili.unichat.lib.packetevents.protocol.dialog.button.CommonButtonData;
import dev.onelili.unichat.lib.packetevents.protocol.nbt.NBT;
import dev.onelili.unichat.lib.packetevents.protocol.nbt.NBTCompound;
import dev.onelili.unichat.lib.packetevents.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ActionButton {
    private final CommonButtonData button;
    private final @Nullable Action action;

    public ActionButton(CommonButtonData button, @Nullable Action action) {
        this.button = button;
        this.action = action;
    }

    public static ActionButton decode(NBT nbt, PacketWrapper<?> wrapper) {
        NBTCompound compound = (NBTCompound)nbt;
        CommonButtonData button = CommonButtonData.decode(compound, wrapper);
        Action action = compound.getOrNull("action", Action::decode, wrapper);
        return new ActionButton(button, action);
    }

    public static NBT encode(PacketWrapper<?> wrapper, ActionButton button) {
        NBTCompound compound = new NBTCompound();
        CommonButtonData.encode(compound, wrapper, button.button);
        if (button.action != null) {
            compound.set("action", button.action, Action::encode, wrapper);
        }
        return compound;
    }

    public CommonButtonData getButton() {
        return this.button;
    }

    public @Nullable Action getAction() {
        return this.action;
    }
}

