/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.packetevents.protocol.entity.cat;

import dev.onelili.unichat.lib.packetevents.protocol.entity.cat.CatVariants;
import dev.onelili.unichat.lib.packetevents.protocol.entity.cat.StaticCatVariant;
import dev.onelili.unichat.lib.packetevents.protocol.mapper.CopyableEntity;
import dev.onelili.unichat.lib.packetevents.protocol.mapper.DeepComparableEntity;
import dev.onelili.unichat.lib.packetevents.protocol.mapper.MappedEntity;
import dev.onelili.unichat.lib.packetevents.protocol.nbt.NBT;
import dev.onelili.unichat.lib.packetevents.protocol.nbt.NBTCompound;
import dev.onelili.unichat.lib.packetevents.protocol.nbt.NBTString;
import dev.onelili.unichat.lib.packetevents.protocol.player.ClientVersion;
import dev.onelili.unichat.lib.packetevents.resources.ResourceLocation;
import dev.onelili.unichat.lib.packetevents.util.mappings.TypesBuilderData;
import dev.onelili.unichat.lib.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public interface CatVariant
extends MappedEntity,
CopyableEntity<CatVariant>,
DeepComparableEntity {
    public ResourceLocation getAssetId();

    public static CatVariant read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntity(CatVariants.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, CatVariant variant) {
        wrapper.writeMappedEntity(variant);
    }

    public static CatVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        return new StaticCatVariant(data, assetId);
    }

    public static NBT encode(CatVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("asset_id", new NBTString(variant.getAssetId().toString()));
        return compound;
    }
}

