/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.packetevents.protocol.entity.frog;

import dev.onelili.unichat.lib.packetevents.protocol.entity.frog.FrogVariants;
import dev.onelili.unichat.lib.packetevents.protocol.entity.frog.StaticFrogVariant;
import dev.onelili.unichat.lib.packetevents.protocol.mapper.CopyableEntity;
import dev.onelili.unichat.lib.packetevents.protocol.mapper.DeepComparableEntity;
import dev.onelili.unichat.lib.packetevents.protocol.mapper.MappedEntity;
import dev.onelili.unichat.lib.packetevents.protocol.nbt.NBT;
import dev.onelili.unichat.lib.packetevents.protocol.nbt.NBTCompound;
import dev.onelili.unichat.lib.packetevents.protocol.nbt.NBTString;
import dev.onelili.unichat.lib.packetevents.protocol.player.ClientVersion;
import dev.onelili.unichat.lib.packetevents.resources.ResourceLocation;
import dev.onelili.unichat.lib.packetevents.util.mappings.TypesBuilderData;
import dev.onelili.unichat.lib.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public interface FrogVariant
extends MappedEntity,
CopyableEntity<FrogVariant>,
DeepComparableEntity {
    public ResourceLocation getAssetId();

    public static FrogVariant read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntity(FrogVariants.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, FrogVariant variant) {
        wrapper.writeMappedEntity(variant);
    }

    public static FrogVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        return new StaticFrogVariant(data, assetId);
    }

    public static NBT encode(FrogVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("asset_id", new NBTString(variant.getAssetId().toString()));
        return compound;
    }
}

