/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.packetevents.protocol.entity.wolfvariant;

import dev.onelili.unichat.lib.packetevents.protocol.entity.wolfvariant.StaticWolfSoundVariant;
import dev.onelili.unichat.lib.packetevents.protocol.entity.wolfvariant.WolfSoundVariants;
import dev.onelili.unichat.lib.packetevents.protocol.mapper.CopyableEntity;
import dev.onelili.unichat.lib.packetevents.protocol.mapper.DeepComparableEntity;
import dev.onelili.unichat.lib.packetevents.protocol.mapper.MappedEntity;
import dev.onelili.unichat.lib.packetevents.protocol.nbt.NBT;
import dev.onelili.unichat.lib.packetevents.protocol.nbt.NBTCompound;
import dev.onelili.unichat.lib.packetevents.protocol.player.ClientVersion;
import dev.onelili.unichat.lib.packetevents.protocol.sound.Sound;
import dev.onelili.unichat.lib.packetevents.util.mappings.TypesBuilderData;
import dev.onelili.unichat.lib.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public interface WolfSoundVariant
extends MappedEntity,
CopyableEntity<WolfSoundVariant>,
DeepComparableEntity {
    public Sound getAmbientSound();

    public Sound getDeathSound();

    public Sound getGrowlSound();

    public Sound getHurtSound();

    public Sound getPantSound();

    public Sound getWhineSound();

    public static WolfSoundVariant read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntity(WolfSoundVariants.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, WolfSoundVariant variant) {
        wrapper.writeMappedEntity(variant);
    }

    public static WolfSoundVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        Sound ambientSound = Sound.decode(compound.getTagOrThrow("ambient_sound"), version);
        Sound deathSound = Sound.decode(compound.getTagOrThrow("death_sound"), version);
        Sound growlSound = Sound.decode(compound.getTagOrThrow("growl_sound"), version);
        Sound hurtSound = Sound.decode(compound.getTagOrThrow("hurt_sound"), version);
        Sound pantSound = Sound.decode(compound.getTagOrThrow("pant_sound"), version);
        Sound whineSound = Sound.decode(compound.getTagOrThrow("whine_sound"), version);
        return new StaticWolfSoundVariant(data, ambientSound, deathSound, growlSound, hurtSound, pantSound, whineSound);
    }

    public static NBT encode(WolfSoundVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("ambient_sound", Sound.encode(variant.getAmbientSound(), version));
        compound.setTag("death_sound", Sound.encode(variant.getDeathSound(), version));
        compound.setTag("growl_sound", Sound.encode(variant.getGrowlSound(), version));
        compound.setTag("hurt_sound", Sound.encode(variant.getHurtSound(), version));
        compound.setTag("pant_sound", Sound.encode(variant.getPantSound(), version));
        compound.setTag("whine_sound", Sound.encode(variant.getWhineSound(), version));
        return compound;
    }
}

