/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.packetevents.protocol.item.instrument;

import dev.onelili.unichat.lib.packetevents.manager.server.ServerVersion;
import dev.onelili.unichat.lib.packetevents.protocol.item.instrument.Instruments;
import dev.onelili.unichat.lib.packetevents.protocol.item.instrument.StaticInstrument;
import dev.onelili.unichat.lib.packetevents.protocol.mapper.CopyableEntity;
import dev.onelili.unichat.lib.packetevents.protocol.mapper.DeepComparableEntity;
import dev.onelili.unichat.lib.packetevents.protocol.mapper.MappedEntity;
import dev.onelili.unichat.lib.packetevents.protocol.nbt.NBT;
import dev.onelili.unichat.lib.packetevents.protocol.nbt.NBTCompound;
import dev.onelili.unichat.lib.packetevents.protocol.nbt.NBTFloat;
import dev.onelili.unichat.lib.packetevents.protocol.player.ClientVersion;
import dev.onelili.unichat.lib.packetevents.protocol.sound.Sound;
import dev.onelili.unichat.lib.packetevents.util.MathUtil;
import dev.onelili.unichat.lib.packetevents.util.mappings.TypesBuilderData;
import dev.onelili.unichat.lib.packetevents.wrapper.PacketWrapper;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.jetbrains.annotations.Nullable;

public interface Instrument
extends MappedEntity,
CopyableEntity<Instrument>,
DeepComparableEntity {
    public Sound getSound();

    public float getUseSeconds();

    default public int getUseDuration() {
        return MathUtil.floor(this.getUseSeconds() * 20.0f);
    }

    public float getRange();

    public Component getDescription();

    public static Instrument read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntityOrDirect(Instruments.getRegistry(), Instrument::readDirect);
    }

    public static Instrument readDirect(PacketWrapper<?> wrapper) {
        Sound sound = Sound.read(wrapper);
        float useSeconds = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2) ? wrapper.readFloat() : (float)wrapper.readVarInt() * 20.0f;
        float range = wrapper.readFloat();
        TextComponent description = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2) ? wrapper.readComponent() : Component.empty();
        return new StaticInstrument(sound, useSeconds, range, (Component)description);
    }

    public static void write(PacketWrapper<?> wrapper, Instrument instrument) {
        wrapper.writeMappedEntityOrDirect(instrument, Instrument::writeDirect);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, Instrument instrument) {
        Sound.write(wrapper, instrument.getSound());
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2)) {
            wrapper.writeFloat(instrument.getUseSeconds());
        } else {
            wrapper.writeVarInt(instrument.getUseDuration());
        }
        wrapper.writeFloat(instrument.getRange());
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2)) {
            wrapper.writeComponent(instrument.getDescription());
        }
    }

    @Deprecated
    public static Instrument decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        return Instrument.decode(nbt, PacketWrapper.createDummyWrapper(version), data);
    }

    public static Instrument decode(NBT nbt, PacketWrapper<?> wrapper, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        Sound sound = compound.getOrThrow("sound_event", Sound::decode, wrapper);
        float useSeconds = compound.getNumberTagOrThrow("use_duration").getAsFloat();
        float range = compound.getNumberTagOrThrow("range").getAsFloat();
        Component description = compound.getOrThrow("description", wrapper.getSerializers(), wrapper);
        return new StaticInstrument(data, sound, useSeconds, range, description);
    }

    @Deprecated
    public static NBT encode(Instrument instrument, ClientVersion version) {
        return Instrument.encode(PacketWrapper.createDummyWrapper(version), instrument);
    }

    public static NBT encode(PacketWrapper<?> wrapper, Instrument instrument) {
        NBTCompound compound = new NBTCompound();
        compound.set("sound_event", instrument.getSound(), Sound::encode, wrapper);
        compound.setTag("use_duration", new NBTFloat(instrument.getUseSeconds()));
        compound.setTag("range", new NBTFloat(instrument.getRange()));
        compound.set("description", instrument.getDescription(), wrapper.getSerializers(), wrapper);
        return compound;
    }
}

