/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.packetevents.protocol.particle.data;

import dev.onelili.unichat.lib.packetevents.manager.server.ServerVersion;
import dev.onelili.unichat.lib.packetevents.protocol.nbt.NBTCompound;
import dev.onelili.unichat.lib.packetevents.protocol.particle.data.LegacyConvertible;
import dev.onelili.unichat.lib.packetevents.protocol.particle.data.LegacyParticleData;
import dev.onelili.unichat.lib.packetevents.protocol.particle.data.ParticleData;
import dev.onelili.unichat.lib.packetevents.protocol.player.ClientVersion;
import dev.onelili.unichat.lib.packetevents.protocol.world.states.WrappedBlockState;
import dev.onelili.unichat.lib.packetevents.wrapper.PacketWrapper;

public class ParticleBlockStateData
extends ParticleData
implements LegacyConvertible {
    private WrappedBlockState blockState;

    public ParticleBlockStateData(WrappedBlockState blockState) {
        this.blockState = blockState;
    }

    public WrappedBlockState getBlockState() {
        return this.blockState;
    }

    public void setBlockState(WrappedBlockState blockState) {
        this.blockState = blockState;
    }

    public static ParticleBlockStateData read(PacketWrapper<?> wrapper) {
        int blockID = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_9) ? wrapper.readVarInt() : (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_13) ? wrapper.readInt() : wrapper.readVarInt());
        return new ParticleBlockStateData(WrappedBlockState.getByGlobalId(wrapper.getServerVersion().toClientVersion(), blockID));
    }

    public static void write(PacketWrapper<?> wrapper, ParticleBlockStateData data) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_9)) {
            wrapper.writeVarInt(data.getBlockState().getGlobalId());
        } else {
            wrapper.writeInt(data.getBlockState().getGlobalId());
        }
    }

    public static ParticleBlockStateData decode(NBTCompound compound, ClientVersion version) {
        String key = version.isNewerThanOrEquals(ClientVersion.V_1_20_5) ? "block_state" : "value";
        WrappedBlockState state = WrappedBlockState.decode(compound.getTagOrThrow(key), version);
        return new ParticleBlockStateData(state);
    }

    public static void encode(ParticleBlockStateData data, ClientVersion version, NBTCompound compound) {
        String key = version.isNewerThanOrEquals(ClientVersion.V_1_20_5) ? "block_state" : "value";
        compound.setTag(key, WrappedBlockState.encode(data.blockState, version));
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public LegacyParticleData toLegacy(ClientVersion version) {
        return LegacyParticleData.ofOne(this.blockState.getGlobalId());
    }
}

