/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.packetevents.protocol.particle.data;

import dev.onelili.unichat.lib.packetevents.manager.server.ServerVersion;
import dev.onelili.unichat.lib.packetevents.protocol.color.Color;
import dev.onelili.unichat.lib.packetevents.protocol.nbt.NBTCompound;
import dev.onelili.unichat.lib.packetevents.protocol.nbt.NBTInt;
import dev.onelili.unichat.lib.packetevents.protocol.particle.data.ParticleData;
import dev.onelili.unichat.lib.packetevents.protocol.player.ClientVersion;
import dev.onelili.unichat.lib.packetevents.util.Vector3d;
import dev.onelili.unichat.lib.packetevents.wrapper.PacketWrapper;

public class ParticleTrailData
extends ParticleData {
    private static final int FALLBACK_DURATION = 25;
    private Vector3d target;
    private Color color;
    private int duration;

    public ParticleTrailData(Vector3d target, Color color) {
        this(target, color, 25);
    }

    public ParticleTrailData(Vector3d target, Color color, int duration) {
        this.target = target;
        this.color = color;
        this.duration = duration;
    }

    public static ParticleTrailData read(PacketWrapper<?> wrapper) {
        Vector3d target = Vector3d.read(wrapper);
        Color color = new Color(wrapper.readInt());
        int duration = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_4) ? wrapper.readVarInt() : 25;
        return new ParticleTrailData(target, color, duration);
    }

    public static void write(PacketWrapper<?> wrapper, ParticleTrailData data) {
        Vector3d.write(wrapper, data.target);
        wrapper.writeInt(data.color.asRGB());
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_4)) {
            wrapper.writeVarInt(data.duration);
        }
    }

    public static ParticleTrailData decode(NBTCompound compound, ClientVersion version) {
        Vector3d target = Vector3d.decode(compound.getTagOrThrow("target"), version);
        Color color = Color.decode(compound.getTagOrThrow("color"), version);
        int duration = 25;
        if (version.isNewerThanOrEquals(ClientVersion.V_1_21_4)) {
            duration = compound.getNumberTagOrThrow("duration").getAsInt();
        }
        return new ParticleTrailData(target, color, duration);
    }

    public static void encode(ParticleTrailData data, ClientVersion version, NBTCompound compound) {
        compound.setTag("target", Vector3d.encode(data.target, version));
        compound.setTag("color", Color.encode(data.color, version));
        if (version.isNewerThanOrEquals(ClientVersion.V_1_21_4)) {
            compound.setTag("duration", new NBTInt(data.duration));
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public Vector3d getTarget() {
        return this.target;
    }

    public void setTarget(Vector3d target) {
        this.target = target;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }
}

