/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.packetevents.protocol.recipe;

import dev.onelili.unichat.lib.packetevents.protocol.recipe.RecipeBookType;
import dev.onelili.unichat.lib.packetevents.wrapper.PacketWrapper;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;

public final class RecipeBookSettings {
    private final Map<RecipeBookType, TypeState> states;

    public RecipeBookSettings(Map<RecipeBookType, TypeState> states) {
        this.states = states;
    }

    public static RecipeBookSettings read(PacketWrapper<?> wrapper) {
        EnumMap<RecipeBookType, TypeState> state = new EnumMap<RecipeBookType, TypeState>(RecipeBookType.class);
        for (RecipeBookType bookType : RecipeBookType.values()) {
            state.put(bookType, TypeState.read(wrapper));
        }
        return new RecipeBookSettings(state);
    }

    public static void write(PacketWrapper<?> wrapper, RecipeBookSettings settings) {
        for (RecipeBookType bookType : RecipeBookType.values()) {
            TypeState.write(wrapper, settings.getState(bookType));
        }
    }

    public TypeState getState(RecipeBookType type) {
        return this.states.computeIfAbsent(type, $ -> new TypeState());
    }

    public void setState(RecipeBookType type, TypeState state) {
        this.states.put(type, state);
    }

    public Map<RecipeBookType, TypeState> getStates() {
        return this.states;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RecipeBookSettings)) {
            return false;
        }
        RecipeBookSettings that = (RecipeBookSettings)obj;
        return this.states.equals(that.states);
    }

    public int hashCode() {
        return Objects.hashCode(this.states);
    }

    public String toString() {
        return "RecipeBookSettings{states=" + this.states + '}';
    }

    public static final class TypeState {
        private static final boolean DEFAULT_OPEN = false;
        private static final boolean DEFAULT_FILTERING = false;
        private boolean open;
        private boolean filtering;

        public TypeState() {
            this(false, false);
        }

        public TypeState(boolean open, boolean filtering) {
            this.open = open;
            this.filtering = filtering;
        }

        public static TypeState read(PacketWrapper<?> wrapper) {
            boolean open = wrapper.readBoolean();
            boolean filtering = wrapper.readBoolean();
            return new TypeState(open, filtering);
        }

        public static void write(PacketWrapper<?> wrapper, TypeState state) {
            wrapper.writeBoolean(state.open);
            wrapper.writeBoolean(state.filtering);
        }

        public boolean isOpen() {
            return this.open;
        }

        public void setOpen(boolean open) {
            this.open = open;
        }

        public boolean isFiltering() {
            return this.filtering;
        }

        public void setFiltering(boolean filtering) {
            this.filtering = filtering;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TypeState)) {
                return false;
            }
            TypeState typeState = (TypeState)obj;
            if (this.open != typeState.open) {
                return false;
            }
            return this.filtering == typeState.filtering;
        }

        public int hashCode() {
            return Objects.hash(this.open, this.filtering);
        }

        public String toString() {
            return "TypeState{open=" + this.open + ", filtering=" + this.filtering + '}';
        }
    }
}

