/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.packetevents.protocol.world.positionsource.builtin;

import dev.onelili.unichat.lib.packetevents.protocol.nbt.NBTCompound;
import dev.onelili.unichat.lib.packetevents.protocol.nbt.NBTIntArray;
import dev.onelili.unichat.lib.packetevents.protocol.player.ClientVersion;
import dev.onelili.unichat.lib.packetevents.protocol.world.positionsource.PositionSource;
import dev.onelili.unichat.lib.packetevents.protocol.world.positionsource.PositionSourceTypes;
import dev.onelili.unichat.lib.packetevents.util.Vector3i;
import dev.onelili.unichat.lib.packetevents.wrapper.PacketWrapper;

public class BlockPositionSource
extends PositionSource {
    private Vector3i pos;

    public BlockPositionSource(Vector3i pos) {
        super(PositionSourceTypes.BLOCK);
        this.pos = pos;
    }

    public static BlockPositionSource read(PacketWrapper<?> wrapper) {
        return new BlockPositionSource(wrapper.readBlockPosition());
    }

    public static void write(PacketWrapper<?> wrapper, BlockPositionSource source) {
        wrapper.writeBlockPosition(source.pos);
    }

    public static BlockPositionSource decodeSource(NBTCompound compound, ClientVersion version) {
        NBTIntArray arr = compound.getTagOfTypeOrThrow("pos", NBTIntArray.class);
        return new BlockPositionSource(new Vector3i(arr.getValue()));
    }

    public static void encodeSource(BlockPositionSource source, ClientVersion version, NBTCompound compound) {
        compound.setTag("pos", new NBTIntArray(new int[]{source.pos.x, source.pos.y, source.pos.z}));
    }

    public Vector3i getPos() {
        return this.pos;
    }

    public void setPos(Vector3i pos) {
        this.pos = pos;
    }
}

