/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.packetevents.wrapper.login.server;

import dev.onelili.unichat.lib.packetevents.event.PacketSendEvent;
import dev.onelili.unichat.lib.packetevents.manager.server.ServerVersion;
import dev.onelili.unichat.lib.packetevents.protocol.packettype.PacketType;
import dev.onelili.unichat.lib.packetevents.protocol.player.TextureProperty;
import dev.onelili.unichat.lib.packetevents.protocol.player.UserProfile;
import dev.onelili.unichat.lib.packetevents.wrapper.PacketWrapper;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;

public class WrapperLoginServerLoginSuccess
extends PacketWrapper<WrapperLoginServerLoginSuccess> {
    private UserProfile userProfile;
    private boolean strictErrorHandling;

    public WrapperLoginServerLoginSuccess(PacketSendEvent event) {
        super(event);
    }

    public WrapperLoginServerLoginSuccess(UUID uuid, String username) {
        this(new UserProfile(uuid, username));
    }

    public WrapperLoginServerLoginSuccess(UserProfile userProfile) {
        this(userProfile, true);
    }

    public WrapperLoginServerLoginSuccess(UserProfile userProfile, boolean strictErrorHandling) {
        super(PacketType.Login.Server.LOGIN_SUCCESS);
        this.userProfile = userProfile;
        this.strictErrorHandling = strictErrorHandling;
    }

    @Override
    public void read() {
        UUID uuid = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16) ? this.readUUID() : UUID.fromString(this.readString(36));
        String username = this.readString(16);
        this.userProfile = new UserProfile(uuid, username);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
            int propertyCount = this.readVarInt();
            for (int i = 0; i < propertyCount; ++i) {
                String propertyName = this.readString();
                String propertyValue = this.readString();
                String propertySignature = (String)this.readOptional(PacketWrapper::readString);
                TextureProperty textureProperty = new TextureProperty(propertyName, propertyValue, propertySignature);
                this.userProfile.getTextureProperties().add(textureProperty);
            }
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_5) && this.serverVersion.isOlderThan(ServerVersion.V_1_21_2)) {
            this.strictErrorHandling = this.readBoolean();
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16)) {
            this.writeUUID(this.userProfile.getUUID());
        } else {
            this.writeString(this.userProfile.getUUID().toString(), 36);
        }
        this.writeString(this.userProfile.getName(), 16);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
            this.writeVarInt(this.userProfile.getTextureProperties().size());
            for (TextureProperty textureProperty : this.userProfile.getTextureProperties()) {
                this.writeString(textureProperty.getName());
                this.writeString(textureProperty.getValue());
                this.writeOptional(textureProperty.getSignature(), PacketWrapper::writeString);
            }
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_5) && this.serverVersion.isOlderThan(ServerVersion.V_1_21_2)) {
            this.writeBoolean(this.strictErrorHandling);
        }
    }

    @Override
    public void copy(WrapperLoginServerLoginSuccess wrapper) {
        this.userProfile = wrapper.userProfile;
    }

    public UserProfile getUserProfile() {
        return this.userProfile;
    }

    public void setUserProfile(UserProfile userProfile) {
        this.userProfile = userProfile;
    }

    @ApiStatus.Obsolete
    public boolean isStrictErrorHandling() {
        return this.strictErrorHandling;
    }

    @ApiStatus.Obsolete
    public void setStrictErrorHandling(boolean strictErrorHandling) {
        this.strictErrorHandling = strictErrorHandling;
    }
}

