/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.packetevents.wrapper.play.server;

import dev.onelili.unichat.lib.packetevents.PacketEvents;
import dev.onelili.unichat.lib.packetevents.event.PacketSendEvent;
import dev.onelili.unichat.lib.packetevents.manager.server.ServerVersion;
import dev.onelili.unichat.lib.packetevents.protocol.entity.data.EntityData;
import dev.onelili.unichat.lib.packetevents.protocol.entity.data.EntityMetadataProvider;
import dev.onelili.unichat.lib.packetevents.protocol.packettype.PacketType;
import dev.onelili.unichat.lib.packetevents.wrapper.PacketWrapper;
import java.util.List;

public class WrapperPlayServerEntityMetadata
extends PacketWrapper<WrapperPlayServerEntityMetadata> {
    private int entityID;
    private List<EntityData<?>> entityMetadata;

    public WrapperPlayServerEntityMetadata(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerEntityMetadata(int entityID, List<EntityData<?>> entityMetadata) {
        super(PacketType.Play.Server.ENTITY_METADATA);
        this.entityID = entityID;
        this.entityMetadata = entityMetadata;
    }

    public WrapperPlayServerEntityMetadata(int entityID, EntityMetadataProvider metadata) {
        this(entityID, metadata.entityData(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion()));
    }

    @Override
    public void read() {
        this.entityID = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8) ? this.readVarInt() : this.readInt();
        this.entityMetadata = this.readEntityMetadata();
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8)) {
            this.writeVarInt(this.entityID);
        } else {
            this.writeInt(this.entityID);
        }
        this.writeEntityMetadata(this.entityMetadata);
    }

    @Override
    public void copy(WrapperPlayServerEntityMetadata wrapper) {
        this.entityID = wrapper.entityID;
        this.entityMetadata = wrapper.entityMetadata;
    }

    public int getEntityId() {
        return this.entityID;
    }

    public void setEntityId(int entityID) {
        this.entityID = entityID;
    }

    public List<EntityData<?>> getEntityMetadata() {
        return this.entityMetadata;
    }

    public void setEntityMetadata(List<EntityData<?>> entityMetadata) {
        this.entityMetadata = entityMetadata;
    }

    public void setEntityMetadata(EntityMetadataProvider metadata) {
        this.entityMetadata = metadata.entityData(this.serverVersion.toClientVersion());
    }
}

