/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.packetevents.wrapper.play.server;

import dev.onelili.unichat.lib.packetevents.event.PacketSendEvent;
import dev.onelili.unichat.lib.packetevents.protocol.packettype.PacketType;
import dev.onelili.unichat.lib.packetevents.wrapper.PacketWrapper;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class WrapperPlayServerPlayerChatHeader
extends PacketWrapper<WrapperPlayServerPlayerChatHeader> {
    private byte @Nullable [] previousSignature;
    private UUID playerUUID;
    private byte[] signature;
    private byte[] hash;

    public WrapperPlayServerPlayerChatHeader(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerPlayerChatHeader(byte @Nullable [] previousSignature, UUID playerUUID, byte[] signature, byte[] hash) {
        super(PacketType.Play.Server.PLAYER_CHAT_HEADER);
        this.previousSignature = previousSignature;
        this.playerUUID = playerUUID;
        this.signature = signature;
        this.hash = hash;
    }

    @Override
    public void read() {
        this.previousSignature = (byte[])this.readOptional(PacketWrapper::readByteArray);
        this.playerUUID = this.readUUID();
        this.signature = this.readByteArray();
        this.hash = this.readByteArray();
    }

    @Override
    public void write() {
        this.writeOptional(this.previousSignature, PacketWrapper::writeByteArray);
        this.writeUUID(this.playerUUID);
        this.writeByteArray(this.signature);
        this.writeByteArray(this.hash);
    }

    @Override
    public void copy(WrapperPlayServerPlayerChatHeader wrapper) {
        this.previousSignature = wrapper.previousSignature;
        this.playerUUID = wrapper.playerUUID;
        this.signature = wrapper.signature;
        this.hash = wrapper.hash;
    }

    public Optional<byte[]> getPreviousSignature() {
        return Optional.ofNullable(this.previousSignature);
    }

    public void setPreviousSignature(byte @Nullable [] previousSignature) {
        this.previousSignature = previousSignature;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public void setPlayerUUID(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public void setHash(byte[] hash) {
        this.hash = hash;
    }
}

