/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.redis.authentication.core;

import dev.onelili.unichat.lib.redis.authentication.core.RenewalTask;
import dev.onelili.unichat.lib.redis.authentication.core.Token;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

class RenewalScheduler {
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private RenewalTask lastTask;
    private Supplier<Token> renewToken;
    private boolean stopped = false;

    public RenewalScheduler(Supplier<Token> renewToken) {
        this.renewToken = renewToken;
    }

    public RenewalTask scheduleNext(long delay) {
        this.lastTask = new RenewalTask(this.scheduler.schedule(() -> this.renewToken.get(), delay, TimeUnit.MILLISECONDS));
        return this.lastTask;
    }

    public RenewalTask getLastTask() {
        return this.lastTask;
    }

    public void waitFor(RenewalTask pendingTask) throws InterruptedException, ExecutionException {
        while (!this.stopped && pendingTask.waitForResultOrError() == null) {
            pendingTask = this.getLastTask();
        }
    }

    public void stop() {
        this.stopped = true;
        this.lastTask.cancel();
        this.scheduler.shutdown();
    }
}

