/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.redis.authentication.core;

import dev.onelili.unichat.lib.redis.authentication.core.Token;
import java.util.Map;

public class SimpleToken
implements Token {
    private String user;
    private String value;
    private long expiresAt;
    private long receivedAt;
    private Map<String, ?> claims;

    public SimpleToken(String user, String value, long expiresAt, long receivedAt, Map<String, ?> claims) {
        this.user = user;
        this.value = value;
        this.expiresAt = expiresAt;
        this.receivedAt = receivedAt;
        this.claims = claims;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public long getExpiresAt() {
        return this.expiresAt;
    }

    @Override
    public long getReceivedAt() {
        return this.receivedAt;
    }

    @Override
    public <T> T tryGet(String key, Class<T> clazz) {
        return (T)this.claims.get(key);
    }

    @Override
    public boolean isExpired() {
        return System.currentTimeMillis() > this.expiresAt;
    }

    @Override
    public long ttl() {
        return this.expiresAt - System.currentTimeMillis();
    }
}

