/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.redis.jedis;

import dev.onelili.unichat.lib.redis.jedis.Connection;
import dev.onelili.unichat.lib.redis.jedis.DefaultJedisClientConfig;
import dev.onelili.unichat.lib.redis.jedis.DefaultJedisSocketFactory;
import dev.onelili.unichat.lib.redis.jedis.HostAndPort;
import dev.onelili.unichat.lib.redis.jedis.JedisClientConfig;
import dev.onelili.unichat.lib.redis.jedis.JedisSocketFactory;
import dev.onelili.unichat.lib.redis.jedis.annots.Experimental;
import dev.onelili.unichat.lib.redis.jedis.authentication.AuthXEventListener;
import dev.onelili.unichat.lib.redis.jedis.authentication.AuthXManager;
import dev.onelili.unichat.lib.redis.jedis.authentication.JedisAuthenticationException;
import dev.onelili.unichat.lib.redis.jedis.csc.Cache;
import dev.onelili.unichat.lib.redis.jedis.csc.CacheConnection;
import dev.onelili.unichat.lib.redis.jedis.exceptions.JedisException;
import java.util.function.Supplier;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactory
implements PooledObjectFactory<Connection> {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionFactory.class);
    private final JedisSocketFactory jedisSocketFactory;
    private final JedisClientConfig clientConfig;
    private final Cache clientSideCache;
    private final Supplier<Connection> objectMaker;
    private final AuthXEventListener authXEventListener;

    public ConnectionFactory(HostAndPort hostAndPort) {
        this(hostAndPort, (JedisClientConfig)DefaultJedisClientConfig.builder().build(), null);
    }

    public ConnectionFactory(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this(hostAndPort, clientConfig, null);
    }

    @Experimental
    public ConnectionFactory(HostAndPort hostAndPort, JedisClientConfig clientConfig, Cache csCache) {
        this(new DefaultJedisSocketFactory(hostAndPort, clientConfig), clientConfig, csCache);
    }

    public ConnectionFactory(JedisSocketFactory jedisSocketFactory, JedisClientConfig clientConfig) {
        this(jedisSocketFactory, clientConfig, null);
    }

    private ConnectionFactory(JedisSocketFactory jedisSocketFactory, JedisClientConfig clientConfig, Cache csCache) {
        this.jedisSocketFactory = jedisSocketFactory;
        this.clientSideCache = csCache;
        this.clientConfig = clientConfig;
        AuthXManager authXManager = clientConfig.getAuthXManager();
        if (authXManager == null) {
            this.objectMaker = this.connectionSupplier();
            this.authXEventListener = AuthXEventListener.NOOP_LISTENER;
        } else {
            Supplier<Connection> supplier = this.connectionSupplier();
            this.objectMaker = () -> authXManager.addConnection((Connection)supplier.get());
            this.authXEventListener = authXManager.getListener();
            authXManager.start();
        }
    }

    private Supplier<Connection> connectionSupplier() {
        return this.clientSideCache == null ? () -> new Connection(this.jedisSocketFactory, this.clientConfig) : () -> new CacheConnection(this.jedisSocketFactory, this.clientConfig, this.clientSideCache);
    }

    @Override
    public void activateObject(PooledObject<Connection> pooledConnection) throws Exception {
    }

    @Override
    public void destroyObject(PooledObject<Connection> pooledConnection) throws Exception {
        Connection jedis = pooledConnection.getObject();
        if (jedis.isConnected()) {
            try {
                jedis.close();
            }
            catch (RuntimeException e) {
                logger.debug("Error while close", e);
            }
        }
    }

    @Override
    public PooledObject<Connection> makeObject() throws Exception {
        try {
            Connection jedis = this.objectMaker.get();
            return new DefaultPooledObject<Connection>(jedis);
        }
        catch (JedisException je) {
            logger.debug("Error while makeObject", je);
            throw je;
        }
    }

    @Override
    public void passivateObject(PooledObject<Connection> pooledConnection) throws Exception {
        Connection jedis = pooledConnection.getObject();
        this.reAuthenticate(jedis);
    }

    @Override
    public boolean validateObject(PooledObject<Connection> pooledConnection) {
        Connection jedis = pooledConnection.getObject();
        try {
            if (!jedis.isConnected()) {
                return false;
            }
            this.reAuthenticate(jedis);
            return jedis.ping();
        }
        catch (Exception e) {
            logger.warn("Error while validating pooled Connection object.", e);
            return false;
        }
    }

    private void reAuthenticate(Connection jedis) throws Exception {
        try {
            String result = jedis.reAuthenticate();
            if (result != null && !result.equals("OK")) {
                String msg = "Re-authentication failed with server response: " + result;
                JedisAuthenticationException failedAuth = new JedisAuthenticationException(msg);
                logger.error(failedAuth.getMessage(), failedAuth);
                this.authXEventListener.onConnectionAuthenticationError(failedAuth);
                return;
            }
        }
        catch (Exception e) {
            logger.error("Error while re-authenticating connection", e);
            this.authXEventListener.onConnectionAuthenticationError(e);
            throw e;
        }
    }
}

