/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.redis.jedis;

import dev.onelili.unichat.lib.redis.jedis.Connection;
import dev.onelili.unichat.lib.redis.jedis.ConnectionFactory;
import dev.onelili.unichat.lib.redis.jedis.HostAndPort;
import dev.onelili.unichat.lib.redis.jedis.JedisClientConfig;
import dev.onelili.unichat.lib.redis.jedis.annots.Experimental;
import dev.onelili.unichat.lib.redis.jedis.authentication.AuthXManager;
import dev.onelili.unichat.lib.redis.jedis.csc.Cache;
import dev.onelili.unichat.lib.redis.jedis.exceptions.JedisException;
import dev.onelili.unichat.lib.redis.jedis.util.Pool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class ConnectionPool
extends Pool<Connection> {
    private AuthXManager authXManager;

    public ConnectionPool(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this(new ConnectionFactory(hostAndPort, clientConfig));
        this.attachAuthenticationListener(clientConfig.getAuthXManager());
    }

    @Experimental
    public ConnectionPool(HostAndPort hostAndPort, JedisClientConfig clientConfig, Cache clientSideCache) {
        this(new ConnectionFactory(hostAndPort, clientConfig, clientSideCache));
        this.attachAuthenticationListener(clientConfig.getAuthXManager());
    }

    public ConnectionPool(PooledObjectFactory<Connection> factory) {
        super(factory);
    }

    public ConnectionPool(HostAndPort hostAndPort, JedisClientConfig clientConfig, GenericObjectPoolConfig<Connection> poolConfig) {
        this(new ConnectionFactory(hostAndPort, clientConfig), poolConfig);
        this.attachAuthenticationListener(clientConfig.getAuthXManager());
    }

    @Experimental
    public ConnectionPool(HostAndPort hostAndPort, JedisClientConfig clientConfig, Cache clientSideCache, GenericObjectPoolConfig<Connection> poolConfig) {
        this(new ConnectionFactory(hostAndPort, clientConfig, clientSideCache), poolConfig);
        this.attachAuthenticationListener(clientConfig.getAuthXManager());
    }

    public ConnectionPool(PooledObjectFactory<Connection> factory, GenericObjectPoolConfig<Connection> poolConfig) {
        super(factory, poolConfig);
    }

    @Override
    public Connection getResource() {
        Connection conn = (Connection)super.getResource();
        conn.setHandlingPool(this);
        return conn;
    }

    @Override
    public void close() {
        try {
            if (this.authXManager != null) {
                this.authXManager.stop();
            }
        }
        finally {
            super.close();
        }
    }

    private void attachAuthenticationListener(AuthXManager authXManager) {
        this.authXManager = authXManager;
        if (authXManager != null) {
            authXManager.addPostAuthenticationHook(token -> {
                try {
                    this.evict();
                }
                catch (Exception e) {
                    throw new JedisException("Failed to evict connections from pool", e);
                }
            });
        }
    }
}

