/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.redis.jedis;

import dev.onelili.unichat.lib.redis.jedis.HostAndPort;
import dev.onelili.unichat.lib.redis.jedis.HostAndPortMapper;
import dev.onelili.unichat.lib.redis.jedis.JedisClientConfig;
import dev.onelili.unichat.lib.redis.jedis.JedisSocketFactory;
import dev.onelili.unichat.lib.redis.jedis.SSLSocketWrapper;
import dev.onelili.unichat.lib.redis.jedis.SslOptions;
import dev.onelili.unichat.lib.redis.jedis.exceptions.JedisConnectionException;
import dev.onelili.unichat.lib.redis.jedis.util.IOUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class DefaultJedisSocketFactory
implements JedisSocketFactory {
    protected static final HostAndPort DEFAULT_HOST_AND_PORT = new HostAndPort("127.0.0.1", 6379);
    private volatile HostAndPort hostAndPort = DEFAULT_HOST_AND_PORT;
    private int connectionTimeout = 2000;
    private int socketTimeout = 2000;
    private boolean ssl = false;
    private SSLSocketFactory sslSocketFactory = null;
    private SslOptions sslOptions = null;
    private SSLParameters sslParameters = null;
    private HostnameVerifier hostnameVerifier = null;
    private HostAndPortMapper hostAndPortMapper = null;

    public DefaultJedisSocketFactory() {
    }

    public DefaultJedisSocketFactory(HostAndPort hostAndPort) {
        this(hostAndPort, null);
    }

    public DefaultJedisSocketFactory(JedisClientConfig config) {
        this(null, config);
    }

    public DefaultJedisSocketFactory(HostAndPort hostAndPort, JedisClientConfig config) {
        if (hostAndPort != null) {
            this.hostAndPort = hostAndPort;
        }
        if (config != null) {
            this.connectionTimeout = config.getConnectionTimeoutMillis();
            this.socketTimeout = config.getSocketTimeoutMillis();
            this.ssl = config.isSsl();
            this.sslSocketFactory = config.getSslSocketFactory();
            this.sslParameters = config.getSslParameters();
            this.sslOptions = config.getSslOptions();
            this.hostnameVerifier = config.getHostnameVerifier();
            this.hostAndPortMapper = config.getHostAndPortMapper();
        }
    }

    private Socket connectToFirstSuccessfulHost(HostAndPort hostAndPort) throws Exception {
        List<InetAddress> hosts = Arrays.asList(InetAddress.getAllByName(hostAndPort.getHost()));
        if (hosts.size() > 1) {
            Collections.shuffle(hosts);
        }
        JedisConnectionException jce = new JedisConnectionException("Failed to connect to " + hostAndPort + ".");
        for (InetAddress host : hosts) {
            try {
                Socket socket = new Socket();
                socket.setReuseAddress(true);
                socket.setKeepAlive(true);
                socket.setTcpNoDelay(true);
                socket.setSoLinger(true, 0);
                socket.connect(new InetSocketAddress(host, hostAndPort.getPort()), this.connectionTimeout);
                return socket;
            }
            catch (Exception e) {
                jce.addSuppressed(e);
            }
        }
        throw jce;
    }

    @Override
    public Socket createSocket() throws JedisConnectionException {
        Socket socket = null;
        try {
            HostAndPort _hostAndPort = this.getSocketHostAndPort();
            socket = this.connectToFirstSuccessfulHost(_hostAndPort);
            socket.setSoTimeout(this.socketTimeout);
            if (this.ssl || this.sslOptions != null) {
                socket = this.createSslSocket(_hostAndPort, socket);
            }
            return socket;
        }
        catch (Exception ex) {
            IOUtils.closeQuietly(socket);
            if (ex instanceof JedisConnectionException) {
                throw (JedisConnectionException)ex;
            }
            throw new JedisConnectionException("Failed to create socket.", ex);
        }
    }

    private Socket createSslSocket(HostAndPort _hostAndPort, Socket socket) throws IOException, GeneralSecurityException {
        SSLParameters _sslParameters;
        SSLSocketFactory _sslSocketFactory;
        Socket plainSocket = socket;
        if (this.sslOptions != null) {
            SSLContext _sslContext = this.sslOptions.createSslContext();
            _sslSocketFactory = _sslContext.getSocketFactory();
            _sslParameters = this.sslOptions.getSslParameters();
        } else {
            _sslSocketFactory = this.sslSocketFactory;
            _sslParameters = this.sslParameters;
        }
        if (_sslSocketFactory == null) {
            _sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        SSLSocket sslSocket = (SSLSocket)_sslSocketFactory.createSocket(socket, _hostAndPort.getHost(), _hostAndPort.getPort(), true);
        if (_sslParameters != null) {
            sslSocket.setSSLParameters(_sslParameters);
        }
        if (this.hostnameVerifier != null && !this.hostnameVerifier.verify(_hostAndPort.getHost(), sslSocket.getSession())) {
            String message = String.format("The connection to '%s' failed ssl/tls hostname verification.", _hostAndPort.getHost());
            throw new JedisConnectionException(message);
        }
        return new SSLSocketWrapper(sslSocket, plainSocket);
    }

    public void updateHostAndPort(HostAndPort hostAndPort) {
        this.hostAndPort = hostAndPort;
    }

    public HostAndPort getHostAndPort() {
        return this.hostAndPort;
    }

    protected HostAndPort getSocketHostAndPort() {
        HostAndPort mapped;
        HostAndPortMapper mapper = this.hostAndPortMapper;
        HostAndPort hap = this.hostAndPort;
        if (mapper != null && (mapped = mapper.getHostAndPort(hap)) != null) {
            return mapped;
        }
        return hap;
    }

    public String toString() {
        return "DefaultJedisSocketFactory{" + this.hostAndPort.toString() + "}";
    }
}

