/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.redis.jedis;

import dev.onelili.unichat.lib.redis.jedis.Connection;
import dev.onelili.unichat.lib.redis.jedis.JedisSafeAuthenticator;
import dev.onelili.unichat.lib.redis.jedis.Protocol;
import dev.onelili.unichat.lib.redis.jedis.RedisProtocol;
import dev.onelili.unichat.lib.redis.jedis.exceptions.JedisException;
import dev.onelili.unichat.lib.redis.jedis.util.SafeEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

public abstract class JedisShardedPubSubBase<T> {
    private int subscribedChannels = 0;
    private final JedisSafeAuthenticator authenticator = new JedisSafeAuthenticator();

    public void onSMessage(T channel, T message) {
    }

    public void onSSubscribe(T channel, int subscribedChannels) {
    }

    public void onSUnsubscribe(T channel, int subscribedChannels) {
    }

    private void sendAndFlushCommand(Protocol.Command command, T ... args) {
        this.authenticator.sendAndFlushCommand(command, args);
    }

    public final void sunsubscribe() {
        this.sendAndFlushCommand(Protocol.Command.SUNSUBSCRIBE, new Object[0]);
    }

    public final void sunsubscribe(T ... channels) {
        this.sendAndFlushCommand(Protocol.Command.SUNSUBSCRIBE, channels);
    }

    public final void ssubscribe(T ... channels) {
        this.checkConnectionSuitableForPubSub();
        this.sendAndFlushCommand(Protocol.Command.SSUBSCRIBE, channels);
    }

    private void checkConnectionSuitableForPubSub() {
        if (this.authenticator.client.protocol != RedisProtocol.RESP3 && this.authenticator.client.isTokenBasedAuthenticationEnabled()) {
            throw new JedisException("Blocking pub/sub operations are not supported on token-based authentication enabled connections with RESP2 protocol!");
        }
    }

    public final boolean isSubscribed() {
        return this.subscribedChannels > 0;
    }

    public final int getSubscribedChannels() {
        return this.subscribedChannels;
    }

    public final void proceed(Connection client, T ... channels) {
        this.authenticator.registerForAuthentication(client);
        this.authenticator.client.setTimeoutInfinite();
        try {
            this.ssubscribe(channels);
            this.process();
        }
        finally {
            this.authenticator.client.rollbackTimeout();
        }
    }

    protected abstract T encode(byte[] var1);

    private void process() {
        do {
            Object reply;
            if ((reply = this.authenticator.client.getUnflushedObject()) instanceof List) {
                T enchannel;
                byte[] bchannel;
                List listReply = (List)reply;
                Object firstObj = listReply.get(0);
                if (!(firstObj instanceof byte[])) {
                    throw new JedisException("Unknown message type: " + firstObj);
                }
                byte[] resp = (byte[])firstObj;
                if (Arrays.equals(Protocol.ResponseKeyword.SSUBSCRIBE.getRaw(), resp)) {
                    this.subscribedChannels = ((Long)listReply.get(2)).intValue();
                    bchannel = (byte[])listReply.get(1);
                    enchannel = bchannel == null ? null : (T)this.encode(bchannel);
                    this.onSSubscribe(enchannel, this.subscribedChannels);
                    continue;
                }
                if (Arrays.equals(Protocol.ResponseKeyword.SUNSUBSCRIBE.getRaw(), resp)) {
                    this.subscribedChannels = ((Long)listReply.get(2)).intValue();
                    bchannel = (byte[])listReply.get(1);
                    enchannel = bchannel == null ? null : (T)this.encode(bchannel);
                    this.onSUnsubscribe(enchannel, this.subscribedChannels);
                    continue;
                }
                if (Arrays.equals(Protocol.ResponseKeyword.SMESSAGE.getRaw(), resp)) {
                    bchannel = (byte[])listReply.get(1);
                    byte[] bmesg = (byte[])listReply.get(2);
                    T enchannel2 = bchannel == null ? null : (T)this.encode(bchannel);
                    T enmesg = bmesg == null ? null : (T)this.encode(bmesg);
                    this.onSMessage(enchannel2, enmesg);
                    continue;
                }
                throw new JedisException("Unknown message type: " + firstObj);
            }
            if (reply instanceof byte[]) {
                Consumer<Object> resultHandler = this.authenticator.resultHandler.poll();
                if (resultHandler == null) {
                    throw new JedisException("Unexpected message : " + SafeEncoder.encode((byte[])reply));
                }
                resultHandler.accept(reply);
                continue;
            }
            throw new JedisException("Unknown message type: " + reply);
        } while (!Thread.currentThread().isInterrupted() && this.isSubscribed());
    }
}

