/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.redis.jedis;

import dev.onelili.unichat.lib.redis.jedis.SslVerifyMode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Objects;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslOptions {
    private static final Logger logger = LoggerFactory.getLogger(SslOptions.class);
    private final String keyManagerAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
    private final String trustManagerAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
    private final String keyStoreType;
    private final String trustStoreType;
    private final Resource keystoreResource;
    private final char[] keystorePassword;
    private final Resource truststoreResource;
    private final char[] truststorePassword;
    private final SSLParameters sslParameters;
    private final SslVerifyMode sslVerifyMode;
    private final String sslProtocol;
    private static final X509Certificate[] EMPTY_X509_CERTIFICATES = new X509Certificate[0];
    private static final TrustManager INSECURE_TRUST_MANAGER = new X509ExtendedTrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String s) {
            if (logger.isDebugEnabled()) {
                logger.debug("Accepting a client certificate: " + chain[0].getSubjectDN());
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String s) {
            if (logger.isDebugEnabled()) {
                logger.debug("Accepting a server certificate: " + chain[0].getSubjectDN());
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String s, Socket socket) throws CertificateException {
            this.checkClientTrusted(chain, s);
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String s, SSLEngine sslEngine) throws CertificateException {
            this.checkClientTrusted(chain, s);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String s, Socket socket) throws CertificateException {
            this.checkServerTrusted(chain, s);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String s, SSLEngine sslEngine) throws CertificateException {
            this.checkServerTrusted(chain, s);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return EMPTY_X509_CERTIFICATES;
        }
    };

    private SslOptions(Builder builder) {
        this.keyStoreType = builder.keyStoreType;
        this.trustStoreType = builder.trustStoreType;
        this.keystoreResource = builder.keystoreResource;
        this.keystorePassword = builder.keystorePassword;
        this.truststoreResource = builder.truststoreResource;
        this.truststorePassword = builder.truststorePassword;
        this.sslParameters = builder.sslParameters;
        this.sslVerifyMode = builder.sslVerifyMode;
        this.sslProtocol = builder.sslProtocol;
    }

    public static Builder builder() {
        return new Builder();
    }

    public SSLContext createSslContext() throws IOException, GeneralSecurityException {
        Throwable throwable;
        KeyManager[] keyManagers = null;
        TrustManager[] trustManagers = null;
        if (this.sslVerifyMode == SslVerifyMode.FULL) {
            this.sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        } else if (this.sslVerifyMode == SslVerifyMode.CA) {
            this.sslParameters.setEndpointIdentificationAlgorithm("");
        } else if (this.sslVerifyMode == SslVerifyMode.INSECURE) {
            trustManagers = new TrustManager[]{INSECURE_TRUST_MANAGER};
        }
        if (this.keystoreResource != null) {
            KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
            throwable = null;
            try (InputStream keystoreStream = this.keystoreResource.get();){
                keyStore.load(keystoreStream, this.keystorePassword);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this.keyManagerAlgorithm);
            keyManagerFactory.init(keyStore, this.keystorePassword);
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        if (trustManagers == null && this.truststoreResource != null) {
            KeyStore trustStore = KeyStore.getInstance(this.trustStoreType);
            throwable = null;
            try (InputStream truststoreStream = this.truststoreResource.get();){
                trustStore.load(truststoreStream, this.truststorePassword);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this.trustManagerAlgorithm);
            trustManagerFactory.init(trustStore);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        SSLContext sslContext = SSLContext.getInstance(this.sslProtocol);
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    public SSLParameters getSslParameters() {
        return this.sslParameters;
    }

    private static char[] getPassword(char[] chars) {
        return chars != null ? Arrays.copyOf(chars, chars.length) : null;
    }

    public static void assertFile(String keyword, File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("%s file %s does not exist", keyword, file));
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(String.format("%s file %s is not a file", keyword, file));
        }
    }

    @FunctionalInterface
    public static interface Resource {
        public static Resource from(URL url) {
            Objects.requireNonNull(url, "URL must not be null");
            return () -> url.openConnection().getInputStream();
        }

        public static Resource from(File file) {
            Objects.requireNonNull(file, "File must not be null");
            return () -> new FileInputStream(file);
        }

        public InputStream get() throws IOException;
    }

    public static class Builder {
        private String keyStoreType;
        private String trustStoreType;
        private Resource keystoreResource;
        private char[] keystorePassword = null;
        private Resource truststoreResource;
        private char[] truststorePassword = null;
        private SSLParameters sslParameters;
        private SslVerifyMode sslVerifyMode = SslVerifyMode.FULL;
        private String sslProtocol = "TLS";

        private Builder() {
        }

        public Builder keyStoreType(String keyStoreType) {
            this.keyStoreType = Objects.requireNonNull(keyStoreType, "KeyStoreType must not be null");
            return this;
        }

        public Builder trustStoreType(String trustStoreType) {
            this.trustStoreType = Objects.requireNonNull(trustStoreType, "TrustStoreType must not be null");
            return this;
        }

        public Builder keystore(File keystore) {
            return this.keystore(keystore, null);
        }

        public Builder keystore(File keystore, char[] keystorePassword) {
            Objects.requireNonNull(keystore, "Keystore must not be null");
            SslOptions.assertFile("Keystore", keystore);
            return this.keystore(Resource.from(keystore), keystorePassword);
        }

        public Builder keystore(URL keystore) {
            return this.keystore(keystore, null);
        }

        public Builder keystore(URL keystore, char[] keystorePassword) {
            Objects.requireNonNull(keystore, "Keystore must not be null");
            return this.keystore(Resource.from(keystore), keystorePassword);
        }

        public Builder keystore(Resource resource, char[] keystorePassword) {
            this.keystoreResource = Objects.requireNonNull(resource, "Keystore InputStreamProvider must not be null");
            this.keystorePassword = SslOptions.getPassword(keystorePassword);
            return this;
        }

        public Builder truststore(File truststore) {
            return this.truststore(truststore, null);
        }

        public Builder truststore(File truststore, char[] truststorePassword) {
            Objects.requireNonNull(truststore, "Truststore must not be null");
            SslOptions.assertFile("Truststore", truststore);
            return this.truststore(Resource.from(truststore), truststorePassword);
        }

        public Builder truststore(URL truststore) {
            return this.truststore(truststore, null);
        }

        public Builder truststore(URL truststore, char[] truststorePassword) {
            Objects.requireNonNull(truststore, "Truststore must not be null");
            return this.truststore(Resource.from(truststore), truststorePassword);
        }

        public Builder truststore(Resource resource, char[] truststorePassword) {
            this.truststoreResource = Objects.requireNonNull(resource, "Truststore InputStreamProvider must not be null");
            this.truststorePassword = SslOptions.getPassword(truststorePassword);
            return this;
        }

        public Builder sslParameters(SSLParameters sslParameters) {
            this.sslParameters = sslParameters;
            return this;
        }

        public Builder sslVerifyMode(SslVerifyMode sslVerifyMode) {
            this.sslVerifyMode = sslVerifyMode;
            return this;
        }

        public Builder sslProtocol(String protocol) {
            this.sslProtocol = protocol;
            return this;
        }

        public SslOptions build() {
            if (this.sslParameters == null) {
                this.sslParameters = new SSLParameters();
            }
            return new SslOptions(this);
        }
    }
}

