/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.redis.jedis.bloom;

import dev.onelili.unichat.lib.redis.jedis.CommandArguments;
import dev.onelili.unichat.lib.redis.jedis.Protocol;
import dev.onelili.unichat.lib.redis.jedis.bloom.RedisBloomProtocol;
import dev.onelili.unichat.lib.redis.jedis.params.IParams;

public class CFReserveParams
implements IParams {
    private Long bucketSize;
    private Integer maxIterations;
    private Integer expansion;

    public static CFReserveParams reserveParams() {
        return new CFReserveParams();
    }

    public CFReserveParams bucketSize(long bucketSize) {
        this.bucketSize = bucketSize;
        return this;
    }

    public CFReserveParams maxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
        return this;
    }

    public CFReserveParams expansion(int expansion) {
        this.expansion = expansion;
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.bucketSize != null) {
            args.add(RedisBloomProtocol.RedisBloomKeyword.BUCKETSIZE).add(Protocol.toByteArray(this.bucketSize));
        }
        if (this.maxIterations != null) {
            args.add(RedisBloomProtocol.RedisBloomKeyword.MAXITERATIONS).add(Protocol.toByteArray(this.maxIterations));
        }
        if (this.expansion != null) {
            args.add(RedisBloomProtocol.RedisBloomKeyword.EXPANSION).add(Protocol.toByteArray(this.expansion));
        }
    }
}

