/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.redis.jedis.csc;

import dev.onelili.unichat.lib.redis.jedis.CommandObject;
import dev.onelili.unichat.lib.redis.jedis.Connection;
import dev.onelili.unichat.lib.redis.jedis.JedisClientConfig;
import dev.onelili.unichat.lib.redis.jedis.JedisSocketFactory;
import dev.onelili.unichat.lib.redis.jedis.Protocol;
import dev.onelili.unichat.lib.redis.jedis.RedisProtocol;
import dev.onelili.unichat.lib.redis.jedis.commands.ProtocolCommand;
import dev.onelili.unichat.lib.redis.jedis.csc.Cache;
import dev.onelili.unichat.lib.redis.jedis.csc.CacheEntry;
import dev.onelili.unichat.lib.redis.jedis.csc.CacheKey;
import dev.onelili.unichat.lib.redis.jedis.csc.RedisVersion;
import dev.onelili.unichat.lib.redis.jedis.exceptions.JedisException;
import dev.onelili.unichat.lib.redis.jedis.util.RedisInputStream;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

public class CacheConnection
extends Connection {
    private final Cache cache;
    private ReentrantLock lock;
    private static final String REDIS = "redis";
    private static final String MIN_REDIS_VERSION = "7.4";

    public CacheConnection(JedisSocketFactory socketFactory, JedisClientConfig clientConfig, Cache cache) {
        super(socketFactory, clientConfig);
        if (this.protocol != RedisProtocol.RESP3) {
            throw new JedisException("Client side caching is only supported with RESP3.");
        }
        if (!cache.compatibilityMode()) {
            RedisVersion current = new RedisVersion(this.version);
            RedisVersion required = new RedisVersion(MIN_REDIS_VERSION);
            if (!REDIS.equals(this.server) || current.compareTo(required) < 0) {
                throw new JedisException(String.format("Client side caching is only supported with 'Redis %s' or later.", MIN_REDIS_VERSION));
            }
        }
        this.cache = Objects.requireNonNull(cache);
        this.initializeClientSideCache();
    }

    @Override
    protected void initializeFromClientConfig(JedisClientConfig config) {
        this.lock = new ReentrantLock();
        super.initializeFromClientConfig(config);
    }

    @Override
    protected Object protocolRead(RedisInputStream inputStream) {
        this.lock.lock();
        try {
            Object object = Protocol.read(inputStream, this.cache);
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected void protocolReadPushes(RedisInputStream inputStream) {
        if (this.lock.tryLock()) {
            try {
                Protocol.readPushes(inputStream, this.cache, true);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void disconnect() {
        super.disconnect();
        this.cache.flush();
    }

    @Override
    public <T> T executeCommand(CommandObject<T> commandObject) {
        CacheKey<T> cacheKey = new CacheKey<T>(commandObject);
        if (!this.cache.isCacheable(cacheKey)) {
            this.cache.getStats().nonCacheable();
            return super.executeCommand(commandObject);
        }
        CacheEntry<T> cacheEntry = this.cache.get(cacheKey);
        if (cacheEntry != null && (cacheEntry = this.validateEntry(cacheEntry)) != null) {
            this.cache.getStats().hit();
            return cacheEntry.getValue();
        }
        this.cache.getStats().miss();
        T value = super.executeCommand(commandObject);
        cacheEntry = new CacheEntry<T>(cacheKey, value, this);
        this.cache.set(cacheKey, cacheEntry);
        value = cacheEntry.getValue();
        return value;
    }

    public Cache getCache() {
        return this.cache;
    }

    private void initializeClientSideCache() {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, "TRACKING", "ON");
        String reply = this.getStatusCodeReply();
        if (!"OK".equals(reply)) {
            throw new JedisException("Could not enable client tracking. Reply: " + reply);
        }
    }

    private CacheEntry validateEntry(CacheEntry cacheEntry) {
        CacheConnection cacheOwner = cacheEntry.getConnection();
        if (cacheOwner == null || cacheOwner.isBroken() || !cacheOwner.isConnected()) {
            this.cache.delete(cacheEntry.getCacheKey());
            return null;
        }
        try {
            cacheOwner.readPushesWithCheckingBroken();
        }
        catch (JedisException e) {
            this.cache.delete(cacheEntry.getCacheKey());
            return null;
        }
        return this.cache.get(cacheEntry.getCacheKey());
    }
}

