/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.redis.jedis.mcf;

import dev.onelili.unichat.lib.redis.jedis.annots.Experimental;
import dev.onelili.unichat.lib.redis.jedis.exceptions.JedisConnectionException;
import dev.onelili.unichat.lib.redis.jedis.providers.MultiClusterPooledConnectionProvider;
import dev.onelili.unichat.lib.redis.jedis.util.IOUtils;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@Experimental
public class CircuitBreakerFailoverBase
implements AutoCloseable {
    private final Lock lock = new ReentrantLock(true);
    protected final MultiClusterPooledConnectionProvider provider;

    public CircuitBreakerFailoverBase(MultiClusterPooledConnectionProvider provider) {
        this.provider = provider;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.provider);
    }

    protected void clusterFailover(CircuitBreaker circuitBreaker) {
        this.lock.lock();
        try {
            if (!CircuitBreaker.State.FORCED_OPEN.equals((Object)circuitBreaker.getState())) {
                circuitBreaker.transitionToForcedOpenState();
                int activeMultiClusterIndex = this.provider.incrementActiveMultiClusterIndex();
                this.provider.runClusterFailoverPostProcessor(activeMultiClusterIndex);
            } else if (this.provider.isLastClusterCircuitBreakerForcedOpen()) {
                throw new JedisConnectionException("Cluster/database endpoint could not failover since the MultiClusterClientConfig was not provided with an additional cluster/database endpoint according to its prioritized sequence. If applicable, consider failing back OR restarting with an available cluster/database endpoint");
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

