/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.redis.jedis.mcf;

import dev.onelili.unichat.lib.redis.jedis.CommandArguments;
import dev.onelili.unichat.lib.redis.jedis.CommandObject;
import dev.onelili.unichat.lib.redis.jedis.CommandObjects;
import dev.onelili.unichat.lib.redis.jedis.Connection;
import dev.onelili.unichat.lib.redis.jedis.PipelineBase;
import dev.onelili.unichat.lib.redis.jedis.RedisProtocol;
import dev.onelili.unichat.lib.redis.jedis.Response;
import dev.onelili.unichat.lib.redis.jedis.annots.Experimental;
import dev.onelili.unichat.lib.redis.jedis.mcf.CircuitBreakerFailoverConnectionProvider;
import dev.onelili.unichat.lib.redis.jedis.providers.MultiClusterPooledConnectionProvider;
import dev.onelili.unichat.lib.redis.jedis.util.KeyValue;
import java.io.Closeable;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

@Experimental
public class MultiClusterPipeline
extends PipelineBase
implements Closeable {
    private final CircuitBreakerFailoverConnectionProvider failoverProvider;
    private final Queue<KeyValue<CommandArguments, Response<?>>> commands = new LinkedList();

    @Deprecated
    public MultiClusterPipeline(MultiClusterPooledConnectionProvider pooledProvider) {
        super(new CommandObjects());
        this.failoverProvider = new CircuitBreakerFailoverConnectionProvider(pooledProvider);
        try (Connection connection = this.failoverProvider.getConnection();){
            RedisProtocol proto = connection.getRedisProtocol();
            if (proto != null) {
                this.commandObjects.setProtocol(proto);
            }
        }
    }

    public MultiClusterPipeline(MultiClusterPooledConnectionProvider pooledProvider, CommandObjects commandObjects) {
        super(commandObjects);
        this.failoverProvider = new CircuitBreakerFailoverConnectionProvider(pooledProvider);
    }

    @Override
    protected final <T> Response<T> appendCommand(CommandObject<T> commandObject) {
        CommandArguments args = commandObject.getArguments();
        Response<T> response = new Response<T>(commandObject.getBuilder());
        this.commands.add(KeyValue.of(args, response));
        return response;
    }

    @Override
    public void close() {
        this.sync();
    }

    @Override
    public void sync() {
        if (this.commands.isEmpty()) {
            return;
        }
        try (Connection connection = this.failoverProvider.getConnection();){
            this.commands.forEach(command -> connection.sendCommand((CommandArguments)command.getKey()));
            List<Object> unformatted = connection.getMany(this.commands.size());
            unformatted.forEach(rawReply -> ((Response)this.commands.poll().getValue()).set(rawReply));
        }
    }

    public Response<Long> waitReplicas(int replicas, long timeout) {
        return this.appendCommand(this.commandObjects.waitReplicas(replicas, timeout));
    }

    public Response<KeyValue<Long, Long>> waitAOF(long numLocal, long numReplicas, long timeout) {
        return this.appendCommand(this.commandObjects.waitAOF(numLocal, numReplicas, timeout));
    }
}

