/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.redis.jedis.search.schemafields;

import dev.onelili.unichat.lib.redis.jedis.CommandArguments;
import dev.onelili.unichat.lib.redis.jedis.search.FieldName;
import dev.onelili.unichat.lib.redis.jedis.search.SearchProtocol;
import dev.onelili.unichat.lib.redis.jedis.search.schemafields.SchemaField;

public class GeoShapeField
extends SchemaField {
    private final CoordinateSystem system;
    private boolean indexMissing;
    private boolean noIndex;

    public GeoShapeField(String fieldName, CoordinateSystem system) {
        super(fieldName);
        this.system = system;
    }

    public GeoShapeField(FieldName fieldName, CoordinateSystem system) {
        super(fieldName);
        this.system = system;
    }

    public static GeoShapeField of(String fieldName, CoordinateSystem system) {
        return new GeoShapeField(fieldName, system);
    }

    @Override
    public GeoShapeField as(String attribute) {
        super.as(attribute);
        return this;
    }

    public GeoShapeField indexMissing() {
        this.indexMissing = true;
        return this;
    }

    public GeoShapeField noIndex() {
        this.noIndex = true;
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        args.addParams(this.fieldName).add(SearchProtocol.SearchKeyword.GEOSHAPE).add((Object)this.system);
        if (this.indexMissing) {
            args.add(SearchProtocol.SearchKeyword.INDEXMISSING);
        }
        if (this.noIndex) {
            args.add(SearchProtocol.SearchKeyword.NOINDEX);
        }
    }

    public static enum CoordinateSystem {
        FLAT,
        SPHERICAL;

    }
}

