/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.lib.redis.jedis.util;

import dev.onelili.unichat.lib.redis.jedis.CommandKeyArgumentPreProcessor;
import dev.onelili.unichat.lib.redis.jedis.annots.Experimental;
import dev.onelili.unichat.lib.redis.jedis.args.Rawable;
import dev.onelili.unichat.lib.redis.jedis.args.RawableFactory;
import dev.onelili.unichat.lib.redis.jedis.util.SafeEncoder;

@Experimental
public class PrefixedKeyArgumentPreProcessor
implements CommandKeyArgumentPreProcessor {
    private final byte[] prefixBytes;
    private final String prefixString;

    public PrefixedKeyArgumentPreProcessor(String prefix) {
        this(prefix, SafeEncoder.encode(prefix));
    }

    public PrefixedKeyArgumentPreProcessor(String prefixString, byte[] prefixBytes) {
        this.prefixString = prefixString;
        this.prefixBytes = prefixBytes;
    }

    @Override
    public Object actualKey(Object paramKey) {
        return PrefixedKeyArgumentPreProcessor.prefixKey(paramKey, this.prefixString, this.prefixBytes);
    }

    private static Object prefixKey(Object key, String prefixString, byte[] prefixBytes) {
        if (key instanceof Rawable) {
            byte[] raw = ((Rawable)key).getRaw();
            return RawableFactory.from(PrefixedKeyArgumentPreProcessor.prefixKeyWithBytes(raw, prefixBytes));
        }
        if (key instanceof byte[]) {
            return PrefixedKeyArgumentPreProcessor.prefixKeyWithBytes((byte[])key, prefixBytes);
        }
        if (key instanceof String) {
            String raw = (String)key;
            return prefixString + raw;
        }
        throw new IllegalArgumentException("\"" + key.toString() + "\" is not a valid argument.");
    }

    private static byte[] prefixKeyWithBytes(byte[] key, byte[] prefixBytes) {
        byte[] namespaced = new byte[prefixBytes.length + key.length];
        System.arraycopy(prefixBytes, 0, namespaced, 0, prefixBytes.length);
        System.arraycopy(key, 0, namespaced, prefixBytes.length, key.length);
        return namespaced;
    }
}

