/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyReloadEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import dev.onelili.unichat.lib.packetevents.PacketEvents;
import dev.onelili.unichat.velocity.channel.Channel;
import dev.onelili.unichat.velocity.command.ChatHistoryCommand;
import dev.onelili.unichat.velocity.command.DirectMessageCommand;
import dev.onelili.unichat.velocity.command.UniChatCommand;
import dev.onelili.unichat.velocity.handler.ChatHistoryManager;
import dev.onelili.unichat.velocity.handler.EventListener;
import dev.onelili.unichat.velocity.handler.PacketEventListener;
import dev.onelili.unichat.velocity.message.MessageLoader;
import dev.onelili.unichat.velocity.module.PatternModule;
import dev.onelili.unichat.velocity.util.Config;
import io.github.retrooper.packetevents.velocity.factory.VelocityPacketEventsBuilder;
import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;

@Plugin(id="unichat", name="UniChat", version="1.0.0", authors={"oneLiLi", "jason31416"}, dependencies={@Dependency(id="packetevents", optional=true)})
public class UniChat {
    private static UniChat instance;
    private static ProxyServer proxy;
    private static Logger logger;
    private static File dataDirectory;

    @Inject
    public UniChat(@Nonnull ProxyServer proxy, @Nonnull Logger logger, @Nonnull @DataDirectory Path dataDirectory) {
        instance = this;
        UniChat.proxy = proxy;
        UniChat.logger = logger;
        UniChat.dataDirectory = dataDirectory.toFile();
    }

    @Subscribe
    public void onProxyInitialization(@Nonnull ProxyInitializeEvent event) {
        proxy.getEventManager().register((Object)this, (Object)new EventListener());
        Config.init();
        MessageLoader.initialize();
        PacketEvents.setAPI(VelocityPacketEventsBuilder.build(proxy, (PluginContainer)proxy.getPluginManager().fromInstance((Object)this).orElseThrow(), logger, dataDirectory.toPath()));
        PacketEvents.getAPI().getSettings().checkForUpdates(false);
        PacketEvents.getAPI().load();
        PacketEvents.getAPI().getEventManager().registerListener(new PacketEventListener());
        PacketEvents.getAPI().init();
        PatternModule.registerDefaults();
        Channel.loadChannels();
        DirectMessageCommand.registerCommand();
        UniChat.getProxy().getCommandManager().register(UniChat.getProxy().getCommandManager().metaBuilder("unichat").build(), (Command)new UniChatCommand());
        UniChat.getProxy().getCommandManager().register(UniChat.getProxy().getCommandManager().metaBuilder("chathistory").aliases(new String[]{"chathist", "ch"}).build(), (Command)new ChatHistoryCommand());
        ChatHistoryManager.init();
        UniChat.getProxy().getConsoleCommandSource().hasPermission("unichat.chathistory");
        UniChat.getProxy().getConsoleCommandSource().hasPermission("unichat.admin");
        UniChat.getProxy().getConsoleCommandSource().hasPermission("unichat.channel");
    }

    public static void reload() {
        Config.reload();
        MessageLoader.initialize();
        ChatHistoryManager.dataSource.close();
        ChatHistoryManager.init();
        for (CommandMeta commandMetas : Channel.getRegisteredChannelCommands()) {
            UniChat.getProxy().getCommandManager().unregister(commandMetas);
        }
        for (Channel channel : Channel.getChannels().values()) {
            channel.getHandler().destroy();
        }
        Channel.getChannels().clear();
        Channel.loadChannels();
        DirectMessageCommand.registerCommand();
        for (UUID uuid : new HashSet<UUID>(Channel.getPlayerChannels().keySet())) {
            Channel.getPlayerChannels().put(uuid, Channel.defaultChannel);
        }
        logger.info("UniChat reloaded!");
    }

    @Subscribe
    public void onProxyReload(@Nonnull ProxyReloadEvent event) {
        UniChat.reload();
    }

    @Subscribe
    public void onProxyShutdown(@Nonnull ProxyShutdownEvent event) {
        PacketEvents.getAPI().terminate();
    }

    @Generated
    public static UniChat getInstance() {
        return instance;
    }

    @Generated
    public static ProxyServer getProxy() {
        return proxy;
    }

    @Generated
    public static Logger getLogger() {
        return logger;
    }

    @Generated
    public static File getDataDirectory() {
        return dataDirectory;
    }
}

