/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.velocity.channel;

import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.proxy.Player;
import dev.onelili.unichat.velocity.UniChat;
import dev.onelili.unichat.velocity.channel.ChannelHandler;
import dev.onelili.unichat.velocity.channel.type.GlobalChannelHandler;
import dev.onelili.unichat.velocity.channel.type.LocalChannelHandler;
import dev.onelili.unichat.velocity.channel.type.RedisChannelHandler;
import dev.onelili.unichat.velocity.channel.type.RoomChannelHandler;
import dev.onelili.unichat.velocity.util.Config;
import dev.onelili.unichat.velocity.util.Logger;
import dev.onelili.unichat.velocity.util.MapTree;
import dev.onelili.unichat.velocity.util.SimplePlayer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class Channel {
    private static Set<CommandMeta> registeredChannelCommands = new HashSet<CommandMeta>();
    public static Map<String, Channel> channelPrefixes = new ConcurrentHashMap<String, Channel>();
    public static Channel defaultChannel = null;
    private static Map<UUID, Channel> playerChannels = new ConcurrentHashMap<UUID, Channel>();
    private static Map<String, Channel> channels = new ConcurrentHashMap<String, Channel>();
    private static Map<String, Function<Channel, ChannelHandler>> channelTypes = new ConcurrentHashMap<String, Function<Channel, ChannelHandler>>();
    private String id;
    private String displayName;
    private boolean passthrough;
    private ChannelHandler handler;
    private boolean logToConsole;
    private List<String> restrictedServers;
    @Nullable
    private String sendPermission;
    @Nullable
    private String receivePermission;

    public static void registerChannelType(@Nonnull String id, @Nullable Function<Channel, ChannelHandler> handler) {
        channelTypes.put(id.toLowerCase(Locale.ROOT), handler);
    }

    public MapTree getChannelConfig() {
        return Config.getSection("channels." + this.id);
    }

    @Nullable
    public static Channel getPlayerChannel(SimplePlayer player) {
        return playerChannels.get(player.getPlayerUUID());
    }

    @Nullable
    public static Channel getChannel(String id) {
        return channels.get(id.toLowerCase(Locale.ROOT));
    }

    @Nullable
    public static Channel getPlayerChannel(Player player) {
        return playerChannels.get(player.getUniqueId());
    }

    public static void loadChannels() {
        defaultChannel = null;
        channelPrefixes.clear();
        for (String i : Config.getSection("channels").getKeys()) {
            try {
                Channel channel = Channel.builder().id(i).displayName(Config.getString("channels." + i + ".name")).logToConsole(Config.getConfigTree().getBoolean("channels." + i + ".log-console", true)).receivePermission(Config.getConfigTree().getString("channels." + i + ".receive-permission", null)).sendPermission(Config.getConfigTree().getString("channels." + i + ".send-permission", null)).passthrough(Config.getConfigTree().getBoolean("channels." + i + ".passthrough", false)).build();
                channel.handler = channelTypes.get(Config.getString("channels." + i + ".type").toLowerCase(Locale.ROOT)).apply(channel);
                if (Config.contains("channels." + i + ".restricted-servers")) {
                    channel.restrictedServers = (List)Config.getItem("channels." + i + ".restricted-servers");
                }
                channels.put(i.toLowerCase(Locale.ROOT), channel);
                for (String prefix : Config.getConfigTree().getStringList("channels." + i + ".prefixes")) {
                    channelPrefixes.put(prefix.toLowerCase(Locale.ROOT), channel);
                }
                List commands = (List)Config.getItem("channels." + i + ".commands");
                if (!commands.isEmpty()) {
                    CommandMeta meta = UniChat.getProxy().getCommandManager().metaBuilder((String)commands.get(0)).aliases((String[])commands.subList(1, commands.size()).toArray(String[]::new)).build();
                    registeredChannelCommands.add(meta);
                    UniChat.getProxy().getCommandManager().register(meta, (Command)channel.handler.getCommand(channel));
                }
                if (defaultChannel != null) continue;
                defaultChannel = channel;
            }
            catch (Exception e) {
                Logger.error("Failed to load channel " + i);
                e.printStackTrace();
            }
        }
    }

    public static void handleChat(Player player, Channel channel, String message) {
        channel.getHandler().handle(new SimplePlayer(player), message);
    }

    @Generated
    private static ChannelHandler $default$handler() {
        return null;
    }

    @Generated
    private static boolean $default$logToConsole() {
        return true;
    }

    @Generated
    private static List<String> $default$restrictedServers() {
        return new ArrayList<String>();
    }

    @Generated
    private static String $default$sendPermission() {
        return null;
    }

    @Generated
    private static String $default$receivePermission() {
        return null;
    }

    @Generated
    public static ChannelBuilder builder() {
        return new ChannelBuilder();
    }

    @Generated
    private Channel(String id, String displayName, boolean passthrough, ChannelHandler handler, boolean logToConsole, List<String> restrictedServers, @Nullable String sendPermission, @Nullable String receivePermission) {
        this.id = id;
        this.displayName = displayName;
        this.passthrough = passthrough;
        this.handler = handler;
        this.logToConsole = logToConsole;
        this.restrictedServers = restrictedServers;
        this.sendPermission = sendPermission;
        this.receivePermission = receivePermission;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public boolean isPassthrough() {
        return this.passthrough;
    }

    @Generated
    public ChannelHandler getHandler() {
        return this.handler;
    }

    @Generated
    public boolean isLogToConsole() {
        return this.logToConsole;
    }

    @Generated
    public List<String> getRestrictedServers() {
        return this.restrictedServers;
    }

    @Nullable
    @Generated
    public String getSendPermission() {
        return this.sendPermission;
    }

    @Nullable
    @Generated
    public String getReceivePermission() {
        return this.receivePermission;
    }

    @Generated
    public static Set<CommandMeta> getRegisteredChannelCommands() {
        return registeredChannelCommands;
    }

    @Generated
    public static Map<UUID, Channel> getPlayerChannels() {
        return playerChannels;
    }

    @Generated
    public static Map<String, Channel> getChannels() {
        return channels;
    }

    @Generated
    public static Map<String, Function<Channel, ChannelHandler>> getChannelTypes() {
        return channelTypes;
    }

    static {
        Channel.registerChannelType("local", LocalChannelHandler::new);
        Channel.registerChannelType("global", GlobalChannelHandler::new);
        Channel.registerChannelType("redis", RedisChannelHandler::new);
        Channel.registerChannelType("room", RoomChannelHandler::new);
    }

    @Generated
    public static class ChannelBuilder {
        @Generated
        private String id;
        @Generated
        private String displayName;
        @Generated
        private boolean passthrough;
        @Generated
        private boolean handler$set;
        @Generated
        private ChannelHandler handler$value;
        @Generated
        private boolean logToConsole$set;
        @Generated
        private boolean logToConsole$value;
        @Generated
        private boolean restrictedServers$set;
        @Generated
        private List<String> restrictedServers$value;
        @Generated
        private boolean sendPermission$set;
        @Generated
        private String sendPermission$value;
        @Generated
        private boolean receivePermission$set;
        @Generated
        private String receivePermission$value;

        @Generated
        ChannelBuilder() {
        }

        @Generated
        public ChannelBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public ChannelBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Generated
        public ChannelBuilder passthrough(boolean passthrough) {
            this.passthrough = passthrough;
            return this;
        }

        @Generated
        public ChannelBuilder handler(ChannelHandler handler) {
            this.handler$value = handler;
            this.handler$set = true;
            return this;
        }

        @Generated
        public ChannelBuilder logToConsole(boolean logToConsole) {
            this.logToConsole$value = logToConsole;
            this.logToConsole$set = true;
            return this;
        }

        @Generated
        public ChannelBuilder restrictedServers(List<String> restrictedServers) {
            this.restrictedServers$value = restrictedServers;
            this.restrictedServers$set = true;
            return this;
        }

        @Generated
        public ChannelBuilder sendPermission(@Nullable String sendPermission) {
            this.sendPermission$value = sendPermission;
            this.sendPermission$set = true;
            return this;
        }

        @Generated
        public ChannelBuilder receivePermission(@Nullable String receivePermission) {
            this.receivePermission$value = receivePermission;
            this.receivePermission$set = true;
            return this;
        }

        @Generated
        public Channel build() {
            ChannelHandler handler$value = this.handler$value;
            if (!this.handler$set) {
                handler$value = Channel.$default$handler();
            }
            boolean logToConsole$value = this.logToConsole$value;
            if (!this.logToConsole$set) {
                logToConsole$value = Channel.$default$logToConsole();
            }
            List<String> restrictedServers$value = this.restrictedServers$value;
            if (!this.restrictedServers$set) {
                restrictedServers$value = Channel.$default$restrictedServers();
            }
            String sendPermission$value = this.sendPermission$value;
            if (!this.sendPermission$set) {
                sendPermission$value = Channel.$default$sendPermission();
            }
            String receivePermission$value = this.receivePermission$value;
            if (!this.receivePermission$set) {
                receivePermission$value = Channel.$default$receivePermission();
            }
            return new Channel(this.id, this.displayName, this.passthrough, handler$value, logToConsole$value, restrictedServers$value, sendPermission$value, receivePermission$value);
        }

        @Generated
        public String toString() {
            return "Channel.ChannelBuilder(id=" + this.id + ", displayName=" + this.displayName + ", passthrough=" + this.passthrough + ", handler$value=" + String.valueOf(this.handler$value) + ", logToConsole$value=" + this.logToConsole$value + ", restrictedServers$value=" + String.valueOf(this.restrictedServers$value) + ", sendPermission$value=" + this.sendPermission$value + ", receivePermission$value=" + this.receivePermission$value + ")";
        }
    }
}

