/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.velocity.channel.type;

import com.velocitypowered.api.proxy.Player;
import dev.onelili.unichat.lib.redis.jedis.JedisPooled;
import dev.onelili.unichat.lib.redis.jedis.JedisPubSub;
import dev.onelili.unichat.velocity.UniChat;
import dev.onelili.unichat.velocity.channel.Channel;
import dev.onelili.unichat.velocity.channel.ChannelHandler;
import dev.onelili.unichat.velocity.handler.ChatHistoryManager;
import dev.onelili.unichat.velocity.message.Message;
import dev.onelili.unichat.velocity.module.PatternModule;
import dev.onelili.unichat.velocity.util.Config;
import dev.onelili.unichat.velocity.util.Logger;
import dev.onelili.unichat.velocity.util.MapTree;
import dev.onelili.unichat.velocity.util.SimplePlayer;
import javax.annotation.Nonnull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class RedisChannelHandler
implements ChannelHandler {
    private final String address;
    private final int port;
    private final String password;
    private final String username;
    private final JedisPooled jedis;
    private final Channel channel;
    private final Thread thread;

    public RedisChannelHandler(final @Nonnull Channel channel) {
        this.address = channel.getChannelConfig().getString("redis-address");
        this.username = channel.getChannelConfig().getString("redis-user", null);
        this.password = channel.getChannelConfig().getString("redis-password", null);
        this.port = channel.getChannelConfig().getInt("redis-port", 6379);
        this.channel = channel;
        try {
            this.jedis = this.username != null ? new JedisPooled(this.address, this.port, this.username, this.password) : new JedisPooled(this.address, this.port);
            this.thread = new Thread(() -> this.jedis.subscribe(new JedisPubSub(){

                @Override
                public void onMessage(@Nonnull String ch, @Nonnull String messageTree) {
                    MapTree cont = MapTree.fromJson(messageTree);
                    Component message = MiniMessage.miniMessage().deserialize((Object)cont.getString("msg"));
                    String sender = cont.getString("sender");
                    Message msg = new Message(channel.getChannelConfig().getString("format"));
                    msg.add("player", sender);
                    msg.add("server", cont.getString("server"));
                    msg.add("channel", channel.getDisplayName());
                    ChatHistoryManager.recordMessage(sender, channel.getId(), cont.getString("server"), LegacyComponentSerializer.legacyAmpersand().serialize(message));
                    Component component = msg.toComponent().append(message);
                    for (Player receiver : UniChat.getProxy().getAllPlayers()) {
                        if (channel.getReceivePermission() != null && !receiver.hasPermission(channel.getReceivePermission())) continue;
                        receiver.sendMessage(component);
                    }
                    if (channel.isLogToConsole()) {
                        UniChat.getProxy().getConsoleCommandSource().sendMessage(component);
                    }
                }
            }, "unichat-channel-" + channel.getId()));
            this.thread.start();
        }
        catch (Exception e) {
            Logger.error("Failed to connect to Redis server: " + e.getMessage());
            Logger.error("Disabling redis channel: " + channel.getId());
            throw e;
        }
    }

    @Override
    public void destroy() {
        this.thread.interrupt();
        this.jedis.close();
    }

    @Override
    public void handle(@Nonnull SimplePlayer player, @Nonnull String message) {
        Message msg = new Message(this.channel.getChannelConfig().getString("format"));
        msg.add("player", player.getName());
        msg.add("channel", this.channel.getDisplayName());
        MapTree cont = new MapTree().put("msg", MiniMessage.miniMessage().serialize(PatternModule.handleMessage(player.player, message, true))).put("sender", player.getName()).put("server", Config.getString("server-name"));
        this.jedis.publish("unichat-channel-" + this.channel.getId(), cont.toJson());
    }
}

