/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.velocity.command;

import com.velocitypowered.api.command.CommandInvocation;
import com.velocitypowered.api.command.SimpleCommand;
import dev.onelili.unichat.velocity.channel.Channel;
import dev.onelili.unichat.velocity.handler.ChatHistoryManager;
import dev.onelili.unichat.velocity.message.Message;
import dev.onelili.unichat.velocity.util.Config;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SequencedCollection;
import java.util.stream.Stream;

public class ChatHistoryCommand
implements SimpleCommand {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(SimpleCommand.Invocation invocation) {
        Object time;
        String[] args = (String[])invocation.arguments();
        if (args.length == 0) {
            invocation.source().sendMessage(Message.getMessage("command.chat-history.channel-header").toComponent());
            Iterator<Channel> iterator = Channel.getChannels().values().iterator();
            while (iterator.hasNext()) {
                Channel channel = iterator.next();
                invocation.source().sendMessage(Message.getMessage("command.chat-history.channel-item").add("channel_name", channel.getDisplayName()).add("channel_id", channel.getId()).toComponent());
            }
            return;
        }
        if (args[0].equals("search")) {
            int page;
            if (args.length < 4) {
                invocation.source().sendMessage(Message.getMessage("command.invalid-arguments").toComponent());
                return;
            }
            String channelId = args[1];
            try {
                page = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                invocation.source().sendMessage(Message.getMessage("command.invalid-arguments").toComponent());
                return;
            }
            String keyword = String.join((CharSequence)" ", Stream.of(args).skip(3L).toList());
            List<ChatHistoryManager.ChatMessage> chatHistory = ChatHistoryManager.searchHistory(keyword, channelId, Config.getInt("chat-history.message-per-page"), Config.getInt("chat-history.message-per-page") * (page - 1));
            invocation.source().sendMessage(Message.getMessage("command.chat-history.chat-header").add("channel_name", Channel.getChannels().get(channelId).getDisplayName()).toComponent());
            Iterator<ChatHistoryManager.ChatMessage> iterator = chatHistory.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    invocation.source().sendMessage(Message.getMessage("command.chat-history.chat-search-footer").add("channel_id", channelId).add("page_prev", page - 1).add("page_next", page + 1).add("keyword", keyword).toComponent());
                    return;
                }
                ChatHistoryManager.ChatMessage message = iterator.next();
                Date time2 = new Date(message.time());
                invocation.source().sendMessage(Message.getMessage("command.chat-history.chat-item").add("time", String.format("%02d:%02d:%02d", time2.getHours(), time2.getMinutes(), time2.getSeconds())).add("date", time2.toLocaleString()).add("server", message.server()).add("sender", message.sender()).add("message", message.message()).toComponent());
            }
        }
        SequencedCollection chatHistory = List.of();
        if (args.length == 1) {
            channelId = args[0];
            if (!Channel.getChannels().containsKey(channelId)) {
                invocation.source().sendMessage(Message.getMessage("command.channel-not-found").toComponent());
                return;
            }
            chatHistory = ChatHistoryManager.listHistoryBefore(System.currentTimeMillis(), Config.getInt("chat-history.message-per-page"), channelId).reversed();
        } else {
            long timestamp;
            if (args.length != 3) {
                invocation.source().sendMessage(Message.getMessage("command.invalid-arguments").toComponent());
                return;
            }
            channelId = args[0];
            String operator = args[1];
            time = args[2];
            if (!Channel.getChannels().containsKey(channelId)) {
                invocation.source().sendMessage(Message.getMessage("command.channel-not-found").toComponent());
                return;
            }
            try {
                timestamp = Long.parseLong((String)time);
            }
            catch (NumberFormatException e) {
                invocation.source().sendMessage(Message.getMessage("command.invalid-timestamp").toComponent());
                return;
            }
            if (operator.equals("before")) {
                chatHistory = ChatHistoryManager.listHistoryBefore(timestamp, Config.getInt("chat-history.message-per-page"), channelId).reversed();
            } else {
                if (!operator.equals("after")) {
                    invocation.source().sendMessage(Message.getMessage("command.invalid-operator").toComponent());
                    return;
                }
                chatHistory = ChatHistoryManager.listHistoryAfter(timestamp, Config.getInt("chat-history.message-per-page"), channelId);
            }
        }
        if (chatHistory.isEmpty()) {
            invocation.source().sendMessage(Message.getMessage("command.chat-history.empty").toComponent());
            return;
        }
        invocation.source().sendMessage(Message.getMessage("command.chat-history.chat-header").add("channel_id", args[0]).add("channel_name", Channel.getChannels().get(args[0]).getDisplayName()).toComponent());
        Iterator iterator = chatHistory.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                invocation.source().sendMessage(Message.getMessage("command.chat-history.chat-footer").add("channel_id", args[0]).add("timestamp_prev", ((ChatHistoryManager.ChatMessage)chatHistory.get(0)).time() - 1L).add("timestamp_next", ((ChatHistoryManager.ChatMessage)chatHistory.get(chatHistory.size() - 1)).time() + 1L).toComponent());
                return;
            }
            ChatHistoryManager.ChatMessage message = (ChatHistoryManager.ChatMessage)iterator.next();
            time = new Date(message.time());
            invocation.source().sendMessage(Message.getMessage("command.chat-history.chat-item").add("time", String.format("%02d:%02d:%02d", ((Date)time).getHours(), ((Date)time).getMinutes(), ((Date)time).getSeconds())).add("date", ((Date)time).toLocaleString()).add("server", message.server()).add("sender", message.sender()).add("message", message.message()).toComponent());
        }
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        return super.suggest((CommandInvocation)invocation);
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission("unichat.chathistory");
    }
}

