/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.velocity.command;

import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import dev.onelili.unichat.velocity.UniChat;
import dev.onelili.unichat.velocity.channel.Channel;
import dev.onelili.unichat.velocity.handler.ChatHistoryManager;
import dev.onelili.unichat.velocity.message.Message;
import dev.onelili.unichat.velocity.module.PatternModule;
import dev.onelili.unichat.velocity.util.Config;
import dev.onelili.unichat.velocity.util.ShitMountainException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class DirectMessageCommand
implements SimpleCommand {
    public static Map<UUID, UUID> lastMessage = new ConcurrentHashMap<UUID, UUID>();

    public void execute(SimpleCommand.Invocation invocation) {
        String message;
        Player target;
        CommandSource commandSource = invocation.source();
        if (!(commandSource instanceof Player)) {
            return;
        }
        Player sender = (Player)commandSource;
        if (Config.getConfigTree().getStringList("message.message-command").contains(invocation.alias())) {
            if (((String[])invocation.arguments()).length < 2) {
                invocation.source().sendMessage(Message.getMessage("command.msg-usage").toComponent());
                return;
            }
            Optional targetOpt = UniChat.getProxy().getPlayer(((String[])invocation.arguments())[0]);
            if (targetOpt.isEmpty()) {
                sender.sendMessage(Message.getMessage("command.player-not-found").add("player", ((String[])invocation.arguments())[0]).toComponent());
                return;
            }
            target = (Player)targetOpt.get();
            if (target == sender) {
                sender.sendMessage(Message.getMessage("command.msg-self").toComponent());
                return;
            }
            message = String.join((CharSequence)" ", List.of((String[])invocation.arguments()).subList(1, ((String[])invocation.arguments()).length));
        } else if (Config.getConfigTree().getStringList("message.reply-command").contains(invocation.alias())) {
            if (((String[])invocation.arguments()).length < 1) {
                invocation.source().sendMessage(Message.getMessage("command.reply-usage").toComponent());
                return;
            }
            if (!lastMessage.containsKey(sender.getUniqueId()) || UniChat.getProxy().getPlayer(lastMessage.get(sender.getUniqueId())).isEmpty()) {
                sender.sendMessage(Message.getMessage("command.reply-no-last-message").toComponent());
                return;
            }
            target = (Player)UniChat.getProxy().getPlayer(lastMessage.get(sender.getUniqueId())).get();
            message = String.join((CharSequence)" ", List.of((String[])invocation.arguments()));
        } else {
            throw new ShitMountainException("Unknown command alias " + invocation.alias() + " in DirectMessageCommand");
        }
        Component msg = PatternModule.handleMessage(sender, message, false);
        Component inbound = new Message(Config.getString("message.format-inbound")).add("name", sender.getUsername()).toComponent().append(msg);
        Component outbound = new Message(Config.getString("message.format-outbound")).add("name", target.getUsername()).toComponent().append(msg);
        target.sendMessage(inbound);
        sender.sendMessage(outbound);
        lastMessage.put(target.getUniqueId(), sender.getUniqueId());
        lastMessage.put(sender.getUniqueId(), target.getUniqueId());
        ChatHistoryManager.recordMessage(sender.getUsername(), "msg", target.getUsername(), LegacyComponentSerializer.legacyAmpersand().serialize(msg));
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        if (!(invocation.source() instanceof Player)) {
            return List.of();
        }
        if (Config.getConfigTree().getStringList("message.message-command").contains(invocation.alias()) && ((String[])invocation.arguments()).length <= 1) {
            return UniChat.getProxy().getAllPlayers().stream().map(Player::getUsername).toList();
        }
        return List.of();
    }

    public static void registerCommand() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.addAll(Config.getConfigTree().getStringList("message.message-command"));
        commands.addAll(Config.getConfigTree().getStringList("message.reply-command"));
        CommandMeta meta = UniChat.getProxy().getCommandManager().metaBuilder((String)commands.get(0)).aliases((String[])commands.subList(1, commands.size()).toArray(String[]::new)).build();
        Channel.getRegisteredChannelCommands().add(meta);
        UniChat.getProxy().getCommandManager().register(meta, (Command)new DirectMessageCommand());
    }
}

