/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.velocity.handler;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import dev.onelili.unichat.velocity.UniChat;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class ChatHistoryManager {
    public static HikariDataSource dataSource;

    public static void init() {
        HikariConfig otherConfig = new HikariConfig();
        otherConfig.setDriverClassName("org.sqlite.JDBC");
        otherConfig.setJdbcUrl("jdbc:sqlite:" + new File(UniChat.getDataDirectory(), "chathistory.db").getAbsolutePath());
        dataSource = new HikariDataSource(otherConfig);
        try (Connection connection = ChatHistoryManager.getConnection();){
            connection.prepareStatement("CREATE TABLE IF NOT EXISTS chathistory (id INTEGER PRIMARY KEY AUTOINCREMENT, channel VARCHAR(255), sender VARCHAR(255), server VARCHAR(255), message TEXT, time BIGINT)").execute();
        }
    }

    public static Connection getConnection() throws SQLException {
        return dataSource.getConnection();
    }

    public static void recordMessage(String sender, String channel, String server, String message) {
        try (Connection connection = ChatHistoryManager.getConnection();){
            PreparedStatement st = connection.prepareStatement("INSERT INTO chathistory (sender, channel, server, message, time) VALUES (?,?,?,?,?)");
            st.setString(1, sender);
            st.setString(2, channel);
            st.setString(3, server);
            st.setString(4, message);
            st.setLong(5, System.currentTimeMillis());
            st.execute();
        }
    }

    public static List<ChatMessage> searchHistory(String query, @Nullable String channel, int limit, int offset) {
        ArrayList<ChatMessage> arrayList;
        block9: {
            Connection connection = ChatHistoryManager.getConnection();
            try {
                String tmp = "SELECT * FROM chathistory WHERE message LIKE '%' || ? || '%'" + (String)(channel != null ? " AND channel = '" + channel + "'" : "") + " ORDER BY time DESC LIMIT ? OFFSET ?";
                System.out.println(tmp.replaceFirst("\\?", "'" + query + "'").replaceFirst("\\?", String.valueOf(limit)).replaceFirst("\\?", String.valueOf(offset)));
                PreparedStatement st = connection.prepareStatement("SELECT * FROM chathistory WHERE message LIKE '%' || ? || '%'" + (String)(channel != null ? " AND channel = '" + channel + "'" : "") + " ORDER BY time DESC LIMIT ? OFFSET ?");
                st.setString(1, query);
                st.setInt(2, limit);
                st.setInt(3, offset);
                ResultSet rs = st.executeQuery();
                ArrayList<ChatMessage> result = new ArrayList<ChatMessage>();
                while (rs.next()) {
                    result.add(new ChatMessage(rs.getString("sender"), rs.getString("channel"), rs.getString("server"), rs.getString("message"), rs.getLong("time")));
                }
                arrayList = result;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            connection.close();
        }
        return arrayList;
    }

    public static List<ChatMessage> listHistoryBefore(long startTime, int limit, @Nullable String channel) {
        ArrayList<ChatMessage> arrayList;
        block9: {
            Connection connection = ChatHistoryManager.getConnection();
            try {
                PreparedStatement st = connection.prepareStatement("SELECT * FROM chathistory WHERE time <= ?" + (String)(channel != null ? " AND channel = '" + channel + "'" : "") + " ORDER BY time DESC LIMIT ?");
                st.setLong(1, startTime);
                st.setInt(2, limit);
                ResultSet rs = st.executeQuery();
                ArrayList<ChatMessage> result = new ArrayList<ChatMessage>();
                while (rs.next()) {
                    result.add(new ChatMessage(rs.getString("sender"), rs.getString("channel"), rs.getString("server"), rs.getString("message"), rs.getLong("time")));
                }
                arrayList = result;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            connection.close();
        }
        return arrayList;
    }

    public static List<ChatMessage> listHistoryAfter(long startTime, int limit, @Nullable String channel) {
        ArrayList<ChatMessage> arrayList;
        block9: {
            Connection connection = ChatHistoryManager.getConnection();
            try {
                PreparedStatement st = connection.prepareStatement("SELECT * FROM chathistory WHERE time >= ?" + (String)(channel != null ? " AND channel = '" + channel + "'" : "") + " ORDER BY time LIMIT ?");
                st.setLong(1, startTime);
                st.setInt(2, limit);
                ResultSet rs = st.executeQuery();
                ArrayList<ChatMessage> result = new ArrayList<ChatMessage>();
                while (rs.next()) {
                    result.add(new ChatMessage(rs.getString("sender"), rs.getString("channel"), rs.getString("server"), rs.getString("message"), rs.getLong("time")));
                }
                arrayList = result;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            connection.close();
        }
        return arrayList;
    }

    public record ChatMessage(String sender, String channel, String server, String message, long time) {
    }
}

