/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.velocity.handler;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.LoginEvent;
import com.velocitypowered.api.event.player.PlayerChatEvent;
import com.velocitypowered.api.proxy.ServerConnection;
import dev.onelili.unichat.velocity.UniChat;
import dev.onelili.unichat.velocity.channel.Channel;
import dev.onelili.unichat.velocity.command.DirectMessageCommand;
import dev.onelili.unichat.velocity.message.Message;
import dev.onelili.unichat.velocity.util.Config;
import dev.onelili.unichat.velocity.util.PlayerData;
import javax.annotation.Nonnull;

public class EventListener {
    @Subscribe(priority=-32768)
    public void onPlayerChat(@Nonnull PlayerChatEvent event) {
        String message;
        Channel channel;
        if (Channel.channelPrefixes.containsKey(event.getMessage().substring(0, 1))) {
            channel = Channel.channelPrefixes.get(event.getMessage().substring(0, 1));
            message = event.getMessage().substring(1);
        } else {
            channel = Channel.getPlayerChannel(event.getPlayer());
            message = event.getMessage();
        }
        if (channel == null) {
            return;
        }
        if (event.getPlayer().getCurrentServer().isPresent() && channel.isPassthrough() && Config.getConfigTree().getStringList("unhandled-servers").contains(((ServerConnection)event.getPlayer().getCurrentServer().get()).getServerInfo().getName())) {
            return;
        }
        if (event.getPlayer().getCurrentServer().isPresent()) {
            String serverid = ((ServerConnection)event.getPlayer().getCurrentServer().get()).getServerInfo().getName();
            if (channel.getRestrictedServers().contains(serverid)) {
                event.setResult(PlayerChatEvent.ChatResult.denied());
                event.getPlayer().sendMessage(Message.getMessage("chat.channel-declined").toComponent());
                return;
            }
        }
        if (channel.getSendPermission() != null && !event.getPlayer().hasPermission(channel.getSendPermission())) {
            event.getPlayer().sendMessage(Message.getMessage("chat.no-send-permission").toComponent());
            event.setResult(PlayerChatEvent.ChatResult.denied());
            return;
        }
        if (!channel.isPassthrough()) {
            event.setResult(PlayerChatEvent.ChatResult.denied());
        } else if (channel.getChannelConfig().getBoolean("respect-backend", true)) {
            return;
        }
        UniChat.getProxy().getScheduler().buildTask((Object)UniChat.getInstance(), () -> Channel.handleChat(event.getPlayer(), channel, message)).schedule();
    }

    @Subscribe
    public void onPlayerJoin(@Nonnull LoginEvent event) {
        Channel.getPlayerChannels().put(event.getPlayer().getUniqueId(), Channel.defaultChannel);
    }

    @Subscribe
    public void onPlayerLeave(@Nonnull DisconnectEvent event) {
        Channel.getPlayerChannels().remove(event.getPlayer().getUniqueId());
        PlayerData.getPlayerDataMap().remove(event.getPlayer().getUniqueId());
        DirectMessageCommand.lastMessage.remove(event.getPlayer().getUniqueId());
    }
}

