/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.velocity.handler;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import dev.onelili.unichat.lib.packetevents.event.PacketListenerPriority;
import dev.onelili.unichat.lib.packetevents.event.ProtocolPacketEvent;
import dev.onelili.unichat.lib.packetevents.event.SimplePacketListenerAbstract;
import dev.onelili.unichat.lib.packetevents.event.simple.PacketPlayReceiveEvent;
import dev.onelili.unichat.lib.packetevents.event.simple.PacketPlaySendEvent;
import dev.onelili.unichat.lib.packetevents.protocol.ConnectionState;
import dev.onelili.unichat.lib.packetevents.protocol.chat.message.ChatMessage_v1_16;
import dev.onelili.unichat.lib.packetevents.wrapper.PacketWrapper;
import dev.onelili.unichat.lib.packetevents.wrapper.play.client.WrapperPlayClientHeldItemChange;
import dev.onelili.unichat.lib.packetevents.wrapper.play.client.WrapperPlayClientPlayerPosition;
import dev.onelili.unichat.lib.packetevents.wrapper.play.server.WrapperPlayServerChatMessage;
import dev.onelili.unichat.lib.packetevents.wrapper.play.server.WrapperPlayServerHeldItemChange;
import dev.onelili.unichat.lib.packetevents.wrapper.play.server.WrapperPlayServerPlayerPositionAndLook;
import dev.onelili.unichat.velocity.UniChat;
import dev.onelili.unichat.velocity.channel.Channel;
import dev.onelili.unichat.velocity.util.Config;
import dev.onelili.unichat.velocity.util.PlayerData;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class PacketEventListener
extends SimplePacketListenerAbstract {
    public PacketEventListener() {
        super(PacketListenerPriority.NORMAL);
    }

    @Override
    public void onPacketPlaySend(@Nonnull PacketPlaySendEvent event) {
        if (event.getPlayer() == null || ((Player)event.getPlayer()).getCurrentServer().isEmpty() || event.getConnectionState() == ConnectionState.LOGIN) {
            return;
        }
        switch (event.getPacketType()) {
            case CHAT_MESSAGE: {
                WrapperPlayServerChatMessage packet = new WrapperPlayServerChatMessage(event);
                try {
                    Player sender;
                    ChatMessage_v1_16 message = (ChatMessage_v1_16)packet.getMessage();
                    Optional senderOpt = UniChat.getProxy().getPlayer(message.getSenderUUID());
                    if (!senderOpt.isPresent() || !(sender = (Player)senderOpt.get()).getCurrentServer().isPresent()) break;
                    String serverid = ((ServerConnection)sender.getCurrentServer().get()).getServerInfo().getName();
                    Channel channel = Channel.getPlayerChannel(sender);
                    String chatMessage = (String)MiniMessage.miniMessage().serialize(message.getChatContent());
                    if (channel == null || !channel.isPassthrough() || Config.getConfigTree().getStringList("unhandled-servers").contains(serverid)) {
                        return;
                    }
                    if (channel.getChannelConfig().getBoolean("respect-backend", true) && sender.equals(event.getPlayer())) {
                        UniChat.getProxy().getScheduler().buildTask((Object)UniChat.getInstance(), () -> Channel.handleChat((Player)event.getPlayer(), channel, chatMessage)).schedule();
                    }
                    event.setCancelled(true);
                }
                catch (ClassCastException e) {
                    UniChat.getLogger().debug("Failed to cast message in chat packet: {}", (Object)e.getMessage());
                }
                break;
            }
            case PLAYER_POSITION_AND_LOOK: {
                WrapperPlayServerPlayerPositionAndLook packet = new WrapperPlayServerPlayerPositionAndLook(event);
                Player player = (Player)event.getPlayer();
                Objects.requireNonNull(PlayerData.getPlayerDataMap().computeIfAbsent(player.getUniqueId(), uuid -> new PlayerData())).setPosition(packet.getPosition());
                break;
            }
            case HELD_ITEM_CHANGE: {
                WrapperPlayServerHeldItemChange packet = new WrapperPlayServerHeldItemChange(event);
                Player player = (Player)event.getPlayer();
                Objects.requireNonNull(PlayerData.getPlayerDataMap().computeIfAbsent(player.getUniqueId(), uuid -> new PlayerData())).setHandItem(packet.getSlot());
            }
        }
    }

    @Override
    public void onPacketPlayReceive(@Nonnull PacketPlayReceiveEvent event) {
        if (event.getPlayer() == null || ((Player)event.getPlayer()).getCurrentServer().isEmpty() || event.getConnectionState() == ConnectionState.LOGIN) {
            return;
        }
        switch (event.getPacketType()) {
            case PLAYER_POSITION: {
                WrapperPlayClientPlayerPosition packet = new WrapperPlayClientPlayerPosition(event);
                Player player = (Player)event.getPlayer();
                Objects.requireNonNull(PlayerData.getPlayerDataMap().computeIfAbsent(player.getUniqueId(), uuid -> new PlayerData())).setPosition(packet.getPosition());
                break;
            }
            case HELD_ITEM_CHANGE: {
                WrapperPlayClientHeldItemChange packet = new WrapperPlayClientHeldItemChange(event);
                Player player = (Player)event.getPlayer();
                Objects.requireNonNull(PlayerData.getPlayerDataMap().computeIfAbsent(player.getUniqueId(), uuid -> new PlayerData())).setHandItem(packet.getSlot());
            }
        }
    }

    private void printObject(Object obj, String prefix, int depth) {
        for (Field field : obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (depth - 1 <= 0) {
                Object cont = Objects.toString(field.get(obj));
                if (((String)cont).length() > 50) {
                    cont = ((String)cont).substring(0, 30) + "..." + ((String)cont).substring(((String)cont).length() - 20);
                }
                System.out.println(prefix + "- " + field.getName() + " : " + (String)cont);
                continue;
            }
            System.out.println(prefix + "- " + field.getName() + " :");
            this.printObject(field.get(obj), prefix + "  ", depth - 1);
        }
    }

    private void listenTo(ProtocolPacketEvent event, int depth) {
        try {
            PacketWrapper packet = null;
            for (Constructor<?> i : event.getPacketType().getWrapperClass().getConstructors()) {
                if (i.getParameterCount() != 1 || !i.getParameterTypes()[0].isAssignableFrom(event.getClass())) continue;
                packet = (PacketWrapper)i.newInstance(event);
                break;
            }
            System.out.println(event.getClass().getSimpleName() + "(" + ((Player)event.getPlayer()).getUsername() + "): " + String.valueOf(event.getPacketType()));
            if (packet != null && depth > 0) {
                this.printObject(packet, "  ", depth);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

