/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.velocity.util;

import com.velocitypowered.api.proxy.Player;
import dev.onelili.unichat.velocity.message.Message;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.kyori.adventure.bossbar.BossBar;

public class SimplePlayer {
    public final Player player;

    public SimplePlayer(@Nonnull Player player) {
        this.player = player;
    }

    public String getName() {
        return this.player.getUsername();
    }

    public UUID getPlayerUUID() {
        return this.player.getUniqueId();
    }

    public void sendMessage(@Nonnull Message message) {
        this.player.sendMessage(message.toComponent());
    }

    public void finishLogin() {
        throw new UnsupportedOperationException();
    }

    public void kick(@Nonnull Message reason) {
        this.player.disconnect(reason.toComponent());
    }

    public void sendActionBar(@Nonnull Message message) {
        this.player.sendActionBar(message.toComponent());
    }

    public void showBossbar(@Nonnull BossBar bossBar) {
        this.player.showBossBar(bossBar);
    }

    public void hideBossbar(@Nonnull BossBar bossBar) {
        this.player.hideBossBar(bossBar);
    }

    public boolean hasPermission(@Nonnull String permission) {
        return this.player.hasPermission(permission);
    }

    public boolean isOp() {
        return this.player.hasPermission("unichat.admin");
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimplePlayer) {
            SimplePlayer pl = (SimplePlayer)obj;
            return pl.getPlayerUUID().equals(this.getPlayerUUID());
        }
        return false;
    }

    public int hashCode() {
        return this.getPlayerUUID().hashCode();
    }
}

