/*
 * Decompiled with CFR 0.152.
 */
package dev.onelili.unichat.velocity.util;

import dev.onelili.unichat.velocity.util.TimedMap;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;

public class TimedHashMap<K, V>
extends ConcurrentHashMap<K, V>
implements TimedMap<K, V> {
    private final ConcurrentMap<K, Long> timestamps = new ConcurrentHashMap<K, Long>();
    private final ConcurrentMap<K, Long> keyExpirationTimes = new ConcurrentHashMap<K, Long>();
    private final AtomicLong globalExpirationTime = new AtomicLong(60000L);
    private final ScheduledExecutorService cleanupScheduler = Executors.newSingleThreadScheduledExecutor();

    public TimedHashMap(long expirationTime, TimeUnit unit) {
        this.globalExpirationTime.set(unit.toMillis(expirationTime));
        this.scheduleCleanupTask();
    }

    public TimedHashMap() {
        this(60L, TimeUnit.SECONDS);
    }

    public TimedHashMap(int initialCapacity, long expirationTime, TimeUnit unit) {
        super(initialCapacity);
        this.globalExpirationTime.set(unit.toMillis(expirationTime));
        this.scheduleCleanupTask();
    }

    public TimedHashMap(Map<? extends K, ? extends V> m, long expirationTime, TimeUnit unit) {
        super(m);
        this.globalExpirationTime.set(unit.toMillis(expirationTime));
        this.scheduleCleanupTask();
    }

    public TimedHashMap(int initialCapacity, float loadFactor, long expirationTime, TimeUnit unit) {
        super(initialCapacity, loadFactor);
        this.globalExpirationTime.set(unit.toMillis(expirationTime));
        this.scheduleCleanupTask();
    }

    public TimedHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, long expirationTime, TimeUnit unit) {
        super(initialCapacity, loadFactor, concurrencyLevel);
        this.globalExpirationTime.set(unit.toMillis(expirationTime));
        this.scheduleCleanupTask();
    }

    private void scheduleCleanupTask() {
        this.cleanupScheduler.scheduleAtFixedRate(this::removeExpiredEntries, 1L, 1L, TimeUnit.MINUTES);
    }

    @Override
    public void setExpirationTime(long duration, TimeUnit unit) {
        this.globalExpirationTime.set(unit.toMillis(duration));
    }

    @Override
    public long getExpirationTime() {
        return this.globalExpirationTime.get();
    }

    @Override
    public boolean setExpirationTime(K key, long duration, TimeUnit unit) {
        if (!this.containsKey(key)) {
            return false;
        }
        this.keyExpirationTimes.put(key, unit.toMillis(duration));
        return true;
    }

    @Override
    public long getExpirationTime(K key) {
        return this.keyExpirationTimes.getOrDefault(key, -1L);
    }

    @Override
    public boolean renewKey(K key) {
        if (!this.containsKey(key)) {
            return false;
        }
        this.updateTimestamp(key);
        return true;
    }

    private void updateTimestamp(K key) {
        this.timestamps.put(key, System.currentTimeMillis());
    }

    private void removeTimestamp(K key) {
        this.timestamps.remove(key);
        this.keyExpirationTimes.remove(key);
    }

    private long getExpirationTimeForKey(K key) {
        return this.keyExpirationTimes.getOrDefault(key, this.globalExpirationTime.get());
    }

    private boolean isExpired(K key) {
        Long timestamp = (Long)this.timestamps.get(key);
        if (timestamp == null) {
            return true;
        }
        long expirationTime = this.getExpirationTimeForKey(key);
        return System.currentTimeMillis() - timestamp > expirationTime;
    }

    @Override
    public void removeExpiredEntries() {
        try {
            for (Object key : this.timestamps.keySet()) {
                if (!this.isExpired(key)) continue;
                this.remove(key);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @Override
    public long getTimeToLive(K key, TimeUnit unit) {
        long elapsed;
        Long timestamp = (Long)this.timestamps.get(key);
        if (timestamp == null) {
            return -1L;
        }
        long expirationTime = this.getExpirationTimeForKey(key);
        long ttl = expirationTime - (elapsed = System.currentTimeMillis() - timestamp);
        if (ttl <= 0L) {
            return 0L;
        }
        return unit.convert(ttl, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getLastUpdateTime(K key) {
        Long timestamp = (Long)this.timestamps.get(key);
        return timestamp != null ? timestamp : -1L;
    }

    @Override
    public V put(K key, V value) {
        V result = super.put(key, value);
        this.updateTimestamp(key);
        return result;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V result = super.putIfAbsent(key, value);
        if (result == null) {
            this.updateTimestamp(key);
        }
        return result;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        super.putAll(m);
        for (K key : m.keySet()) {
            this.updateTimestamp(key);
        }
    }

    @Override
    public V replace(K key, V value) {
        V result = super.replace(key, value);
        if (result != null) {
            this.updateTimestamp(key);
        }
        return result;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        boolean result = super.replace(key, oldValue, newValue);
        if (result) {
            this.updateTimestamp(key);
        }
        return result;
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V result = super.compute(key, remappingFunction);
        if (result != null) {
            this.updateTimestamp(key);
        }
        return result;
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        V result = super.computeIfAbsent(key, mappingFunction);
        if (result != null) {
            this.updateTimestamp(key);
        }
        return result;
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V result = super.computeIfPresent(key, remappingFunction);
        if (result != null) {
            this.updateTimestamp(key);
        }
        return result;
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        V result = super.merge(key, value, remappingFunction);
        if (result != null) {
            this.updateTimestamp(key);
        }
        return result;
    }

    @Override
    public V remove(Object key) {
        Object result = super.remove(key);
        if (result != null) {
            this.removeTimestamp(key);
        }
        return result;
    }

    @Override
    public boolean remove(Object key, Object value) {
        boolean result = super.remove(key, value);
        if (result) {
            this.removeTimestamp(key);
        }
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        this.timestamps.clear();
        this.keyExpirationTimes.clear();
    }

    @Override
    public V get(Object key) {
        Object value = super.get(key);
        if (value != null && this.isExpired(key)) {
            this.remove(key);
            return null;
        }
        return value;
    }

    @Override
    public boolean containsKey(Object key) {
        if (super.containsKey(key)) {
            if (this.isExpired(key)) {
                this.remove(key);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        this.removeExpiredEntries();
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        this.removeExpiredEntries();
        return super.isEmpty();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.removeExpiredEntries();
        return super.entrySet();
    }

    @Override
    public ConcurrentHashMap.KeySetView<K, V> keySet() {
        this.removeExpiredEntries();
        return super.keySet();
    }

    @Override
    public void shutdown() {
        this.cleanupScheduler.shutdown();
    }
}

