/*
 * Decompiled with CFR 0.152.
 */
package io.github.retrooper.packetevents;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import dev.onelili.unichat.lib.packetevents.PacketEvents;
import dev.onelili.unichat.lib.packetevents.event.PacketListenerAbstract;
import dev.onelili.unichat.lib.packetevents.event.PacketReceiveEvent;
import dev.onelili.unichat.lib.packetevents.event.PacketSendEvent;
import io.github.retrooper.packetevents.bstats.charts.SimplePie;
import io.github.retrooper.packetevents.bstats.velocity.Metrics;
import io.github.retrooper.packetevents.velocity.factory.VelocityPacketEventsBuilder;
import java.nio.file.Path;
import org.slf4j.Logger;

public class PacketEventsPlugin {
    private final ProxyServer server;
    private final Logger logger;
    private final PluginContainer pluginContainer;
    private final Path dataDirectory;
    private final Metrics.Factory metricsFactory;

    @Inject
    public PacketEventsPlugin(ProxyServer server, Logger logger, PluginContainer pluginContainer, @DataDirectory Path dataDirectory, Metrics.Factory metricsFactory) {
        this.server = server;
        this.logger = logger;
        this.pluginContainer = pluginContainer;
        this.dataDirectory = dataDirectory;
        this.metricsFactory = metricsFactory;
    }

    @Subscribe
    public void onProxyInitialize(ProxyInitializeEvent event) {
        this.logger.info("Injecting packetevents...");
        PacketEvents.setAPI(VelocityPacketEventsBuilder.build(this.server, this.pluginContainer, this.logger, this.dataDirectory));
        PacketEvents.getAPI().load();
        PacketListenerAbstract listener = new PacketListenerAbstract(){

            @Override
            public void onPacketReceive(PacketReceiveEvent event) {
            }

            @Override
            public void onPacketSend(PacketSendEvent event) {
            }
        };
        PacketEvents.getAPI().init();
        Metrics metrics = this.metricsFactory.make(this, 11327);
        metrics.addCustomChart(new SimplePie("packetevents_version", () -> PacketEvents.getAPI().getVersion().toStringWithoutSnapshot()));
        this.logger.info("Plugin started");
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        PacketEvents.getAPI().terminate();
    }
}

