/*
 * Decompiled with CFR 0.152.
 */
package io.github.retrooper.packetevents.injector;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import dev.onelili.unichat.lib.packetevents.PacketEvents;
import dev.onelili.unichat.lib.packetevents.injector.ChannelInjector;
import dev.onelili.unichat.lib.packetevents.protocol.player.User;
import dev.onelili.unichat.lib.packetevents.util.reflection.Reflection;
import dev.onelili.unichat.lib.packetevents.util.reflection.ReflectionObject;
import io.github.retrooper.packetevents.handlers.PacketEventsDecoder;
import io.github.retrooper.packetevents.handlers.PacketEventsEncoder;
import io.github.retrooper.packetevents.injector.VelocityChannelInitializer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;

public class VelocityPipelineInjector
implements ChannelInjector {
    private static Class<?> CONNECTION_MANAGER_CLASS;
    private static Class<?> SERVER_INITIALIZER_HOLDER_CLASS;
    private static Class<?> BACKEND_INITIALIZER_HOLDER_CLASS;
    private static Method SET_SERVER_INTIIALIZER;
    private static Method SET_BACKEND_INITIALIZER;
    private final ProxyServer server;

    public VelocityPipelineInjector(ProxyServer server) {
        this.server = server;
    }

    @Override
    public boolean isServerBound() {
        return true;
    }

    @Override
    public void inject() {
        if (CONNECTION_MANAGER_CLASS == null) {
            CONNECTION_MANAGER_CLASS = Reflection.getClassByNameWithoutException("com.velocitypowered.proxy.network.ConnectionManager");
            SERVER_INITIALIZER_HOLDER_CLASS = Reflection.getClassByNameWithoutException("com.velocitypowered.proxy.network.ServerChannelInitializerHolder");
            BACKEND_INITIALIZER_HOLDER_CLASS = Reflection.getClassByNameWithoutException("com.velocitypowered.proxy.network.BackendChannelInitializerHolder");
            SET_SERVER_INTIIALIZER = Reflection.getMethod(SERVER_INITIALIZER_HOLDER_CLASS, 0, ChannelInitializer.class);
            SET_BACKEND_INITIALIZER = Reflection.getMethod(BACKEND_INITIALIZER_HOLDER_CLASS, 0, ChannelInitializer.class);
        }
        ReflectionObject reflectServer = new ReflectionObject(this.server);
        Object connectionManager = reflectServer.readObject(0, CONNECTION_MANAGER_CLASS);
        ReflectionObject reflectConnectionManager = new ReflectionObject(connectionManager);
        Object proxyInitializerHolder = reflectConnectionManager.readObject(0, SERVER_INITIALIZER_HOLDER_CLASS);
        ChannelInitializer wrappedProxyInitializer = (ChannelInitializer)((Supplier)proxyInitializerHolder).get();
        VelocityChannelInitializer initializer = new VelocityChannelInitializer((ChannelInitializer<Channel>)wrappedProxyInitializer);
        try {
            SET_SERVER_INTIIALIZER.invoke(proxyInitializerHolder, new Object[]{initializer});
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void uninject() {
    }

    @Override
    public void updateUser(Object channel, User user) {
        PacketEventsDecoder decoder = (PacketEventsDecoder)((Channel)channel).pipeline().get(PacketEvents.DECODER_NAME);
        decoder.user = user;
        PacketEventsEncoder encoder = (PacketEventsEncoder)((Channel)channel).pipeline().get(PacketEvents.ENCODER_NAME);
        encoder.user = user;
    }

    @Override
    public boolean isPlayerSet(Object ch) {
        if (ch == null) {
            return false;
        }
        Channel channel = (Channel)ch;
        PacketEventsEncoder encoder = (PacketEventsEncoder)channel.pipeline().get(PacketEvents.ENCODER_NAME);
        if (encoder.player != null) {
            return true;
        }
        PacketEventsDecoder decoder = (PacketEventsDecoder)channel.pipeline().get(PacketEvents.DECODER_NAME);
        return decoder.player != null;
    }

    @Override
    public void setPlayer(Object ch, Object p) {
        Channel channel = (Channel)ch;
        Player player = (Player)p;
        PacketEventsDecoder decoder = (PacketEventsDecoder)channel.pipeline().get(PacketEvents.DECODER_NAME);
        decoder.player = player;
        decoder.user.getProfile().setUUID(player.getUniqueId());
        decoder.user.getProfile().setName(player.getUsername());
        PacketEventsEncoder encoder = (PacketEventsEncoder)channel.pipeline().get(PacketEvents.ENCODER_NAME);
        encoder.player = player;
    }

    @Override
    public boolean isProxy() {
        return true;
    }
}

