/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.core.registry.block;

import java.util.Random;
import net.magicvt.extravagantdelight.core.registry.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BarleyCropBlock
extends Block
implements BonemealableBlock {
    public static final int MAX_AGE = 7;
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)7);
    public static final IntegerProperty HEIGHT = IntegerProperty.m_61631_((String)"height", (int)1, (int)2);
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0)};

    public BarleyCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)HEIGHT, (Comparable)Integer.valueOf(1)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, HEIGHT});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age == 3) {
            return Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
        }
        return SHAPE_BY_AGE[Math.min(age, SHAPE_BY_AGE.length - 1)];
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int age;
        if ((Integer)state.m_61143_((Property)HEIGHT) == 1 && (age = ((Integer)state.m_61143_((Property)AGE)).intValue()) < 7 && random.m_188503_(25) == 0) {
            this.grow(world, pos, age + 1);
        }
    }

    private void grow(ServerLevel world, BlockPos pos, int newAge) {
        BlockState aboveState;
        BlockPos abovePos;
        BlockState state = world.m_8055_(pos);
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(newAge)));
        if (newAge >= 4 && (Integer)state.m_61143_((Property)HEIGHT) == 1) {
            abovePos = pos.m_7494_();
            aboveState = world.m_8055_(abovePos);
            if (!(aboveState.m_60734_() instanceof BarleyCropBlock) || (Integer)aboveState.m_61143_((Property)HEIGHT) != 2) {
                world.m_46597_(abovePos, (BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(newAge))).m_61124_((Property)HEIGHT, (Comparable)Integer.valueOf(2)));
            } else {
                world.m_46597_(abovePos, (BlockState)aboveState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(newAge)));
            }
        }
        if (newAge < 4 && (Integer)state.m_61143_((Property)HEIGHT) == 1 && (aboveState = world.m_8055_(abovePos = pos.m_7494_())).m_60734_() instanceof BarleyCropBlock && (Integer)aboveState.m_61143_((Property)HEIGHT) == 2) {
            world.m_7471_(abovePos, false);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        if ((Integer)state.m_61143_((Property)HEIGHT) == 2) {
            BlockState belowState = world.m_8055_(pos.m_7495_());
            return belowState.m_60734_() instanceof BarleyCropBlock && (Integer)belowState.m_61143_((Property)HEIGHT) == 1;
        }
        BlockState soil = world.m_8055_(pos.m_7495_());
        return soil.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("extravagantdelight", "plantable_on_farmland")));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!world.f_46443_ && !this.m_7898_(state, (LevelReader)world, pos)) {
            BlockPos abovePos;
            BlockState aboveState;
            world.m_46961_(pos, true);
            if ((Integer)state.m_61143_((Property)HEIGHT) == 1 && (aboveState = world.m_8055_(abovePos = pos.m_7494_())).m_60734_() instanceof BarleyCropBlock && (Integer)aboveState.m_61143_((Property)HEIGHT) == 2) {
                world.m_46961_(abovePos, false);
            }
        }
        super.m_6861_(state, world, pos, block, fromPos, isMoving);
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.m_61143_((Property)AGE) < 7;
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        int newAge = Math.min((Integer)state.m_61143_((Property)AGE) + 1 + random.m_188503_(2), 7);
        if ((Integer)state.m_61143_((Property)HEIGHT) == 2) {
            BlockPos belowPos = pos.m_7495_();
            BlockState belowState = world.m_8055_(belowPos);
            if (belowState.m_60734_() instanceof BarleyCropBlock && (Integer)belowState.m_61143_((Property)HEIGHT) == 1) {
                this.grow(world, belowPos, newAge);
            }
        } else {
            this.grow(world, pos, newAge);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!world.f_46443_ && state.m_60734_() != newState.m_60734_()) {
            BlockPos belowPos;
            BlockState belowState;
            if ((Integer)state.m_61143_((Property)HEIGHT) == 1) {
                BlockPos abovePos = pos.m_7494_();
                BlockState aboveState = world.m_8055_(abovePos);
                if (aboveState.m_60734_() instanceof BarleyCropBlock && (Integer)aboveState.m_61143_((Property)HEIGHT) == 2) {
                    world.m_46597_(abovePos, Blocks.f_50016_.m_49966_());
                }
            } else if ((Integer)state.m_61143_((Property)HEIGHT) == 2 && (belowState = world.m_8055_(belowPos = pos.m_7495_())).m_60734_() instanceof BarleyCropBlock && (Integer)belowState.m_61143_((Property)HEIGHT) == 1) {
                if ((Integer)belowState.m_61143_((Property)AGE) == 7) {
                    Random random = new Random();
                    int barleyCount = 1 + random.nextInt(3);
                    int seedsCount = 1 + random.nextInt(2);
                    BarleyCropBlock.m_49840_((Level)world, (BlockPos)belowPos, (ItemStack)new ItemStack((ItemLike)ModItems.BARLEY.get(), barleyCount));
                    BarleyCropBlock.m_49840_((Level)world, (BlockPos)belowPos, (ItemStack)new ItemStack((ItemLike)ModItems.BARLEY_SEEDS.get(), seedsCount));
                }
                world.m_46597_(belowPos, Blocks.f_50016_.m_49966_());
            }
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity, ItemStack tool) {
        if (!world.f_46443_ && (Integer)state.m_61143_((Property)HEIGHT) == 1 && (Integer)state.m_61143_((Property)AGE) == 7) {
            Random random = new Random();
            int barleyCount = 1 + random.nextInt(3);
            int seedsCount = 1 + random.nextInt(2);
            BarleyCropBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModItems.BARLEY.get(), barleyCount));
            BarleyCropBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModItems.BARLEY_SEEDS.get(), seedsCount));
        }
        super.m_6240_(world, player, pos, state, blockEntity, tool);
    }
}

