/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.core.registry.block;

import net.magicvt.extravagantdelight.core.registry.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StarfruitCropBlock
extends Block
implements BonemealableBlock {
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)4);
    public static final int MAX_AGE = 4;
    public static final EnumProperty<DoubleBlockHalf> HALF = EnumProperty.m_61587_((String)"half", DoubleBlockHalf.class);
    private static final VoxelShape LOWER_SHAPE = Blocks.f_50132_.m_5940_(Blocks.f_50132_.m_49966_(), null, BlockPos.f_121853_, CollisionContext.m_82749_());
    private static final VoxelShape UPPER_SHAPE = Blocks.f_50398_.m_5940_(Blocks.f_50398_.m_49966_(), null, BlockPos.f_121853_, CollisionContext.m_82749_());

    public StarfruitCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, HALF});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return LOWER_SHAPE;
        }
        int age = (Integer)state.m_61143_((Property)AGE);
        return age >= 2 ? UPPER_SHAPE : Shapes.m_83040_();
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            BlockState below = level.m_8055_(pos.m_7495_());
            return below.m_60713_((Block)this) && below.m_61143_(HALF) == DoubleBlockHalf.LOWER;
        }
        BlockState soil = level.m_8055_(pos.m_7495_());
        return soil.m_60713_(Blocks.f_49992_) || soil.m_60713_(Blocks.f_49993_);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN && !state.m_60710_((LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)ModItems.STARFRUIT_SEEDS.get());
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (state.m_61143_(HALF) != DoubleBlockHalf.LOWER) {
            return;
        }
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age >= 4) {
            return;
        }
        if (level.m_45524_(pos, 0) >= 9 && random.m_188503_(5) == 0) {
            int newAge = age + 1;
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(newAge)), 2);
            BlockPos abovePos = pos.m_7494_();
            BlockState aboveState = level.m_8055_(abovePos);
            if (!aboveState.m_60713_((Block)this)) {
                level.m_7731_(abovePos, (BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(newAge))).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
            } else {
                level.m_7731_(abovePos, (BlockState)aboveState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(newAge)), 2);
            }
        }
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        if ((Integer)state.m_61143_((Property)AGE) >= 4) {
            return false;
        }
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            BlockState belowState = world.m_8055_(pos.m_7495_());
            return belowState.m_60713_((Block)this) && (Integer)belowState.m_61143_((Property)AGE) < 4;
        }
        return true;
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos lowerPos = state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos;
        BlockState lowerState = world.m_8055_(lowerPos);
        int age = (Integer)lowerState.m_61143_((Property)AGE);
        if (age < 4) {
            int newAge = Math.min(4, age + 1);
            world.m_7731_(lowerPos, (BlockState)lowerState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(newAge)), 2);
            BlockPos abovePos = lowerPos.m_7494_();
            BlockState aboveState = world.m_8055_(abovePos);
            if (!aboveState.m_60713_((Block)this)) {
                world.m_7731_(abovePos, (BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(newAge))).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
            } else {
                world.m_7731_(abovePos, (BlockState)aboveState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(newAge)), 2);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if ((Integer)state.m_61143_((Property)AGE) == 4) {
            BlockPos lowerPos = state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos;
            BlockState lowerState = level.m_8055_(lowerPos);
            BlockState upperState = level.m_8055_(lowerPos.m_7494_());
            if (!lowerState.m_60713_((Block)this) || (Integer)lowerState.m_61143_((Property)AGE) != 4) {
                return super.m_6227_(state, level, pos, player, hand, hit);
            }
            int amount = 2 + level.f_46441_.m_188503_(4);
            ItemStack fruit = new ItemStack((ItemLike)ModItems.STARFRUIT.get(), amount);
            StarfruitCropBlock.m_49840_((Level)level, (BlockPos)lowerPos, (ItemStack)fruit);
            level.m_5594_(null, lowerPos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_7731_(lowerPos, (BlockState)lowerState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(3)), 3);
            if (upperState.m_60713_((Block)this)) {
                level.m_7731_(lowerPos.m_7494_(), (BlockState)upperState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(3)), 3);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                BlockPos abovePos = pos.m_7494_();
                BlockState aboveState = level.m_8055_(abovePos);
                if (aboveState.m_60713_((Block)this) && aboveState.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
                    level.m_46961_(abovePos, false);
                }
            } else {
                BlockPos belowPos = pos.m_7495_();
                BlockState belowState = level.m_8055_(belowPos);
                if (belowState.m_60713_((Block)this) && belowState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                    level.m_46961_(belowPos, false);
                }
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockPos belowPos;
        BlockState belowState;
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER && !(belowState = level.m_8055_(belowPos = pos.m_7495_())).m_60713_((Block)this)) {
            level.m_46961_(pos, true);
        }
        super.m_6807_(state, level, pos, oldState, isMoving);
    }
}

