/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.core.registry.block.entity;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.magicvt.extravagantdelight.core.registry.block.SorbetMakerBlock;
import net.magicvt.extravagantdelight.core.registry.block.entity.ModBlockEntities;
import net.magicvt.extravagantdelight.core.registry.screen.SorbetMakerMenu;
import net.magicvt.extravagantdelight.recipe.ModRecipes;
import net.magicvt.extravagantdelight.recipe.SorbetMakerRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class SorbetMakerBlockEntity
extends BlockEntity
implements MenuProvider,
WorldlyContainer {
    private final ItemStackHandler itemHandler = new ItemStackHandler(18){

        protected void onContentsChanged(int slot) {
            SorbetMakerBlockEntity.this.m_6596_();
            if (SorbetMakerBlockEntity.this.f_58857_ != null) {
                SorbetMakerBlockEntity.this.f_58857_.m_7260_(SorbetMakerBlockEntity.this.f_58858_, SorbetMakerBlockEntity.this.m_58900_(), SorbetMakerBlockEntity.this.m_58900_(), 3);
            }
        }
    };
    private final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> SorbetMakerBlockEntity.this.progress;
                case 1 -> SorbetMakerBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    SorbetMakerBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    SorbetMakerBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 100;
    private boolean craftingPaused = true;
    private int recipeIndex = 0;

    public SorbetMakerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SORBET_MAKER.get(), pos, state);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.extravagantdelight.sorbet_maker");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new SorbetMakerMenu(id, inventory, this, this.data);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && side != null) {
            SidedInvWrapper handler = new SidedInvWrapper((WorldlyContainer)this, side);
            return LazyOptional.of(() -> SorbetMakerBlockEntity.lambda$getCapability$0((IItemHandler)handler)).cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("progress", this.progress);
        tag.m_128405_("maxProgress", this.maxProgress);
        tag.m_128379_("craftingPaused", this.craftingPaused);
        tag.m_128405_("recipeIndex", this.recipeIndex);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("inventory")) {
            this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        }
        this.progress = tag.m_128451_("progress");
        this.maxProgress = tag.m_128441_("maxProgress") ? tag.m_128451_("maxProgress") : this.maxProgress;
        this.craftingPaused = tag.m_128471_("craftingPaused");
        this.recipeIndex = tag.m_128451_("recipeIndex");
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SorbetMakerBlockEntity entity) {
        if (level.m_5776_()) {
            return;
        }
        boolean blockOpen = (Boolean)state.m_61143_((Property)SorbetMakerBlock.OPEN);
        if (!blockOpen && SorbetMakerBlockEntity.hasAnyRecipe(entity)) {
            entity.craftingPaused = false;
            ++entity.progress;
            if (entity.progress == 1) {
                level.m_5594_(null, pos, SoundEvents.f_11983_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (entity.progress >= entity.maxProgress) {
                SorbetMakerBlockEntity.craftItem(entity);
                entity.progress = 0;
                level.m_5594_(null, pos, SoundEvents.f_12474_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    RandomSource rand = serverLevel.m_213780_();
                    for (int i = 0; i < 8; ++i) {
                        double x = (double)pos.m_123341_() + 0.3 + rand.m_188500_() * 0.4;
                        double y = (double)pos.m_123342_() + 1.0;
                        double z = (double)pos.m_123343_() + 0.3 + rand.m_188500_() * 0.4;
                        double vx = (rand.m_188500_() - 0.5) * 0.02;
                        double vy = 0.02 + rand.m_188500_() * 0.02;
                        double vz = (rand.m_188500_() - 0.5) * 0.02;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, x, y, z, 1, vx, vy, vz, 0.0);
                    }
                }
                entity.m_6596_();
            } else if (entity.progress % 20 == 0) {
                level.m_5594_(null, pos, SoundEvents.f_12483_, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
        } else if (blockOpen) {
            entity.craftingPaused = true;
        } else {
            entity.progress = 0;
            entity.craftingPaused = true;
        }
    }

    private static boolean hasAnyRecipe(SorbetMakerBlockEntity entity) {
        Level level = entity.f_58857_;
        if (level == null) {
            return false;
        }
        SimpleContainer inv = entity.createSimpleContainer();
        List<SorbetMakerRecipe> recipes = level.m_7465_().m_44013_((RecipeType)ModRecipes.SORBET_MAKER_TYPE.get()).stream().filter(r -> r.matches(inv, level)).toList();
        if (recipes.isEmpty()) {
            return false;
        }
        SorbetMakerRecipe recipe = recipes.get(entity.recipeIndex % recipes.size());
        ItemStack containerStack = entity.itemHandler.getStackInSlot(9);
        return recipe.getContainer().m_43947_() || recipe.getContainer().test(containerStack);
    }

    private static void craftItem(SorbetMakerBlockEntity entity) {
        ItemStack containerStack;
        Level level = entity.f_58857_;
        if (level == null) {
            return;
        }
        SimpleContainer inv = entity.createSimpleContainer();
        List<SorbetMakerRecipe> recipes = level.m_7465_().m_44013_((RecipeType)ModRecipes.SORBET_MAKER_TYPE.get()).stream().filter(r -> r.matches(inv, level)).toList();
        if (recipes.isEmpty()) {
            return;
        }
        SorbetMakerRecipe recipe = recipes.get(entity.recipeIndex % recipes.size());
        ++entity.recipeIndex;
        for (SorbetMakerRecipe.CountedIngredient ci : recipe.getCountedIngredients()) {
            int needed = ci.count;
            for (int slot = 0; slot < 9 && needed > 0; ++slot) {
                ItemStack stackInSlot = entity.itemHandler.getStackInSlot(slot);
                if (stackInSlot.m_41619_() || !ci.ingredient.test(stackInSlot)) continue;
                int take = Math.min(needed, stackInSlot.m_41613_());
                stackInSlot.m_41774_(take);
                needed -= take;
                entity.itemHandler.setStackInSlot(slot, stackInSlot);
            }
        }
        if (!recipe.getContainer().m_43947_() && !(containerStack = entity.itemHandler.getStackInSlot(9)).m_41619_()) {
            containerStack.m_41774_(1);
            entity.itemHandler.setStackInSlot(9, containerStack);
        }
        SorbetMakerBlockEntity.insertResultIntoOutputs(entity, recipe.m_8043_(level.m_9598_()).m_41777_());
        for (ItemStack secondary : recipe.getSecondaryResults()) {
            if (secondary.m_41619_()) continue;
            SorbetMakerBlockEntity.insertResultIntoOutputs(entity, secondary.m_41777_());
        }
        entity.m_6596_();
    }

    private static void insertResultIntoOutputs(SorbetMakerBlockEntity entity, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        for (int i = 10; i < 18 && !stack.m_41619_(); ++i) {
            int space;
            ItemStack out = entity.itemHandler.getStackInSlot(i);
            if (out.m_41619_()) {
                int put = Math.min(stack.m_41613_(), stack.m_41741_());
                ItemStack toPut = stack.m_41777_();
                toPut.m_41764_(put);
                entity.itemHandler.setStackInSlot(i, toPut);
                stack.m_41774_(put);
                continue;
            }
            if (!ItemStack.m_150942_((ItemStack)out, (ItemStack)stack) || (space = out.m_41741_() - out.m_41613_()) <= 0) continue;
            int put = Math.min(space, stack.m_41613_());
            out.m_41769_(put);
            stack.m_41774_(put);
            entity.itemHandler.setStackInSlot(i, out);
        }
        if (!stack.m_41619_()) {
            entity.f_58857_.m_7967_((Entity)new ItemEntity(entity.f_58857_, (double)entity.f_58858_.m_123341_() + 0.5, (double)entity.f_58858_.m_123342_() + 1.0, (double)entity.f_58858_.m_123343_() + 0.5, stack.m_41777_()));
        }
    }

    private SimpleContainer createSimpleContainer() {
        SimpleContainer inv = new SimpleContainer(10);
        for (int i = 0; i < 10; ++i) {
            inv.m_6836_(i, this.itemHandler.getStackInSlot(i).m_41777_());
        }
        return inv;
    }

    public void setCraftingPaused(boolean paused) {
        this.craftingPaused = paused;
    }

    public boolean isCraftingPaused() {
        return this.craftingPaused;
    }

    public int getProgress() {
        return this.progress;
    }

    public ContainerData getContainerData() {
        return this.data;
    }

    public int m_6643_() {
        return 18;
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack stack = this.itemHandler.extractItem(slot, amount, false);
        if (!stack.m_41619_()) {
            this.m_6596_();
        }
        return stack;
    }

    public ItemStack m_8016_(int slot) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        if (!stack.m_41619_()) {
            this.itemHandler.setStackInSlot(slot, ItemStack.f_41583_);
            this.m_6596_();
        }
        return stack;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.itemHandler.setStackInSlot(slot, stack);
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_ == null) {
            return false;
        }
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public int[] m_7071_(Direction side) {
        if (side == Direction.DOWN) {
            return new int[]{10, 11, 12, 13, 14, 15, 16, 17};
        }
        if (side == Direction.UP) {
            return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        }
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
    }

    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction dir) {
        return slot < 10;
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return slot >= 10 && slot < 18;
    }

    private static /* synthetic */ IItemHandler lambda$getCapability$0(IItemHandler handler) {
        return handler;
    }
}

