/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.core.registry.block.grapefruit;

import javax.annotation.Nullable;
import net.magicvt.extravagantdelight.core.registry.entity.GrapefruitEntity;
import net.magicvt.extravagantdelight.core.registry.entity.ModEntities;
import net.magicvt.extravagantdelight.core.registry.item.ModItems;
import net.magicvt.extravagantdelight.core.registry.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GrapefruitBlock
extends Block {
    public static final IntegerProperty GRAPES = IntegerProperty.m_61631_((String)"grapes", (int)0, (int)2);
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);

    public GrapefruitBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(0.5f).m_60918_(SoundType.f_56760_).m_60955_().m_278166_(PushReaction.DESTROY));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)GRAPES, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{GRAPES});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!world.m_5776_()) {
            this.checkAndDrop(world, pos);
        }
        super.m_6807_(state, world, pos, oldState, isMoving);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!world.m_5776_()) {
            this.checkAndDrop(world, pos);
        }
        super.m_6861_(state, world, pos, block, fromPos, isMoving);
    }

    private void checkAndDrop(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (world.m_8055_(pos.m_7495_()).m_60795_()) {
            world.m_7471_(pos, false);
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                int grapes = (Integer)state.m_61143_((Property)GRAPES);
                int count = grapes + 1;
                for (int i = 0; i < count; ++i) {
                    double offsetX = (world.f_46441_.m_188500_() - 0.5) * 0.4;
                    double offsetZ = (world.f_46441_.m_188500_() - 0.5) * 0.4;
                    double x = (double)pos.m_123341_() + 0.5 + offsetX;
                    double y = (double)pos.m_123342_() + 0.3;
                    double z = (double)pos.m_123343_() + 0.5 + offsetZ;
                    EntityType entityType = (EntityType)ModEntities.GRAPEFRUIT.get();
                    GrapefruitEntity grapefruit = (GrapefruitEntity)entityType.m_20615_((Level)serverLevel);
                    if (grapefruit == null) continue;
                    double velocityX = (world.f_46441_.m_188500_() - 0.5) * 0.6;
                    double velocityY = 0.25 + world.f_46441_.m_188500_() * 0.2;
                    double velocityZ = (world.f_46441_.m_188500_() - 0.5) * 0.6;
                    grapefruit.m_7678_(x, y, z, world.f_46441_.m_188501_() * 360.0f, 0.0f);
                    grapefruit.m_20334_(velocityX, velocityY, velocityZ);
                    serverLevel.m_7967_((Entity)grapefruit);
                }
            }
        }
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!level.m_5776_() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 300));
            level.m_5594_(null, pos, (SoundEvent)ModSounds.GRAPEFRUIT_SQUISH.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
            level.m_46961_(pos, false);
        }
        super.m_141947_(level, pos, state, entity);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack stack) {
        if (!level.m_5776_()) {
            int grapes = (Integer)state.m_61143_((Property)GRAPES);
            GrapefruitBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModItems.GRAPEFRUIT.get(), grapes + 1));
        }
        super.m_6240_(level, player, pos, state, blockEntity, stack);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ModItems.GRAPEFRUIT.get());
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int current;
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41720_() == ModItems.GRAPEFRUIT.get() && (current = ((Integer)state.m_61143_((Property)GRAPES)).intValue()) < 2) {
            if (!level.m_5776_()) {
                BlockState newState = (BlockState)state.m_61124_((Property)GRAPES, (Comparable)Integer.valueOf(current + 1));
                level.m_7731_(pos, newState, 3);
                level.m_7260_(pos, state, newState, 3);
                if (!player.m_150110_().f_35937_) {
                    heldItem.m_41774_(1);
                }
                level.m_5594_(null, pos, SoundEvents.f_144241_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return !world.m_8055_(pos.m_7495_()).m_60795_();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        if (level.m_8055_((pos = context.m_8083_()).m_7495_()).m_60734_() instanceof GrapefruitBlock) {
            return null;
        }
        return this.m_49966_();
    }
}

