/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.core.registry.block.mango;

import java.util.ArrayList;
import java.util.Collections;
import net.magicvt.extravagantdelight.core.registry.block.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class YoungMangoTreeBlock
extends Block
implements BonemealableBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);

    public YoungMangoTreeBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF});
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            BlockState below = world.m_8055_(pos.m_7495_());
            return below.m_60734_() == this && below.m_61143_(HALF) == DoubleBlockHalf.LOWER;
        }
        BlockState soil = world.m_8055_(pos.m_7495_());
        return soil.m_204336_(BlockTags.f_144274_) || soil.m_60713_(Blocks.f_50093_) || soil.m_60713_(Blocks.f_50440_);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        if (half == DoubleBlockHalf.UPPER && direction == Direction.DOWN && (neighborState.m_60734_() != this || neighborState.m_61143_(HALF) != DoubleBlockHalf.LOWER)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (half == DoubleBlockHalf.LOWER && direction == Direction.UP && (neighborState.m_60734_() != this || neighborState.m_61143_(HALF) != DoubleBlockHalf.UPPER)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (world.m_5776_()) {
            return;
        }
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER && random.m_188503_(10) == 0) {
            this.growTree(world, pos, random);
        }
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER;
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            this.growTree(world, pos, random);
        }
    }

    private void growTree(ServerLevel world, BlockPos pos, RandomSource random) {
        world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        world.m_7731_(pos.m_7494_(), Blocks.f_50016_.m_49966_(), 3);
        int height = 5 + random.m_188503_(3);
        for (int y = 0; y < height; ++y) {
            BlockPos logPos = pos.m_6630_(y);
            world.m_7731_(logPos, ((Block)ModBlocks.MANGO_LOG.get()).m_49966_(), 3);
        }
        BlockPos top = pos.m_6630_(height - 1);
        int branchCount = 4;
        for (int i = 0; i < branchCount; ++i) {
            Direction dir = Direction.m_122407_((int)i);
            int branchStartY = height - 2 - random.m_188503_(2);
            BlockPos branchStart = pos.m_6630_(branchStartY);
            int branchLength = 3 + random.m_188503_(2);
            BlockPos branchPos = branchStart;
            for (int j = 0; j < branchLength; ++j) {
                branchPos = branchPos.m_121945_(dir);
                BlockState logState = ((Block)ModBlocks.MANGO_LOG.get()).m_49966_();
                if (dir.m_122434_() == Direction.Axis.X) {
                    logState = (BlockState)logState.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.X);
                } else if (dir.m_122434_() == Direction.Axis.Z) {
                    logState = (BlockState)logState.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Z);
                }
                world.m_7731_(branchPos, logState, 3);
                this.placeLeavesLayer(world, branchPos.m_7495_(), 3, 0.8f, random, false);
            }
        }
        this.generateJungleStyleTreetop(world, top, random);
    }

    private void generateJungleStyleTreetop(ServerLevel world, BlockPos center, RandomSource random) {
        world.m_7731_(center.m_6630_(1), ((Block)ModBlocks.MANGO_LOG.get()).m_49966_(), 3);
        int radius = 5;
        this.placeLeavesLayer(world, center.m_7495_(), radius + 1, 0.95f, random, true);
        this.placeLeavesLayer(world, center, radius, 0.95f, random, true);
        this.placeLeavesLayer(world, center.m_7494_(), radius - 1, 0.9f, random, false);
        this.placeFlatLeavesLayer(world, center.m_6630_(2), radius - 2, 0.85f, random);
        this.ensureExternalFlourishingLeaves(world, center, radius, random);
    }

    private void ensureExternalFlourishingLeaves(ServerLevel world, BlockPos center, int radius, RandomSource random) {
        int flourishingCount = 0;
        ArrayList<BlockPos> candidatePositions = new ArrayList<BlockPos>();
        int[][] layers = new int[][]{{center.m_123342_() - 1, radius + 1}, {center.m_123342_(), radius}, {center.m_123342_() + 1, radius - 1}, {center.m_123342_() + 2, radius - 2}};
        for (int[] layer : layers) {
            int layerY = layer[0];
            int layerRadius = layer[1];
            for (int dx = -layerRadius; dx <= layerRadius; ++dx) {
                for (int dz = -layerRadius; dz <= layerRadius; ++dz) {
                    double dist;
                    BlockPos pos = new BlockPos(center.m_123341_() + dx, layerY, center.m_123343_() + dz);
                    BlockState state = world.m_8055_(pos);
                    if (!state.m_60713_((Block)ModBlocks.MANGO_LEAVES.get()) || !((dist = Math.sqrt(dx * dx + dz * dz)) > (double)layerRadius - 1.5) || !this.isExternalSurface(world, pos)) continue;
                    candidatePositions.add(pos);
                }
            }
        }
        Object object = candidatePositions.iterator();
        while (object.hasNext()) {
            BlockPos pos = (BlockPos)object.next();
            if (!world.m_8055_(pos).m_60713_((Block)ModBlocks.FLOURISHING_MANGO_LEAVES.get())) continue;
            ++flourishingCount;
        }
        int targetCount = 5 + random.m_188503_(6);
        int toAdd = Math.max(0, targetCount - flourishingCount);
        if (toAdd > 0 && !candidatePositions.isEmpty()) {
            Collections.shuffle(candidatePositions);
            for (int i = 0; i < Math.min(toAdd, candidatePositions.size()); ++i) {
                BlockPos pos = (BlockPos)candidatePositions.get(i);
                if (!world.m_8055_(pos).m_60713_((Block)ModBlocks.MANGO_LEAVES.get())) continue;
                world.m_7731_(pos, ((Block)ModBlocks.FLOURISHING_MANGO_LEAVES.get()).m_49966_(), 3);
            }
        }
    }

    private boolean isExternalSurface(ServerLevel world, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos = pos.m_121945_(direction);
            BlockState adjacentState = world.m_8055_(adjacentPos);
            if (adjacentState.m_60795_()) {
                return true;
            }
            if (adjacentState.m_60713_((Block)ModBlocks.MANGO_LEAVES.get()) || adjacentState.m_60713_((Block)ModBlocks.FLOURISHING_MANGO_LEAVES.get()) || adjacentState.m_60713_((Block)ModBlocks.MANGO_LOG.get())) continue;
            return true;
        }
        return false;
    }

    private void placeLeavesLayer(ServerLevel world, BlockPos center, int radius, float density, RandomSource random, boolean makeBlockyCenter) {
        int innerRadius = Math.max(1, (int)((double)radius * 0.6));
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos pos = center.m_7918_(dx, dy, dz);
                    Block block = world.m_8055_(pos).m_60734_();
                    if (block == ModBlocks.MANGO_LOG.get()) continue;
                    double chebyshevDist = Math.max(Math.abs(dx), Math.abs(dz));
                    double euclideanDist = Math.sqrt(dx * dx + dz * dz);
                    boolean placeLeaves = false;
                    if (makeBlockyCenter) {
                        if (chebyshevDist <= (double)innerRadius) {
                            placeLeaves = true;
                        } else if (euclideanDist <= (double)radius) {
                            placeLeaves = random.m_188501_() < density;
                        }
                    } else if (euclideanDist <= (double)radius) {
                        boolean bl = placeLeaves = random.m_188501_() < density;
                    }
                    if (!placeLeaves) continue;
                    BlockState toPlace = ((Block)ModBlocks.MANGO_LEAVES.get()).m_49966_();
                    if (toPlace.m_61138_((Property)BlockStateProperties.f_61362_)) {
                        toPlace = (BlockState)toPlace.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
                    }
                    world.m_7731_(pos, toPlace, 3);
                }
            }
        }
    }

    private void placeFlatLeavesLayer(ServerLevel world, BlockPos center, int radius, float density, RandomSource random) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                double dist;
                BlockPos pos = center.m_7918_(dx, 0, dz);
                Block block = world.m_8055_(pos).m_60734_();
                if (block == ModBlocks.MANGO_LOG.get() || (dist = Math.sqrt(dx * dx + dz * dz)) > (double)radius || !(random.m_188501_() < density)) continue;
                BlockState toPlace = ((Block)ModBlocks.MANGO_LEAVES.get()).m_49966_();
                if (toPlace.m_61138_((Property)BlockStateProperties.f_61362_)) {
                    toPlace = (BlockState)toPlace.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
                }
                world.m_7731_(pos, toPlace, 3);
            }
        }
    }

    public static void placeAt(LevelAccessor world, BlockPos pos, int flags) {
        world.m_7731_(pos, (BlockState)((Block)ModBlocks.YOUNG_MANGO_TREE.get()).m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER), flags);
        world.m_7731_(pos.m_7494_(), (BlockState)((Block)ModBlocks.YOUNG_MANGO_TREE.get()).m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), flags);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                BlockPos up = pos.m_7494_();
                if (world.m_8055_(up).m_60734_() == this) {
                    world.m_7731_(up, Blocks.f_50016_.m_49966_(), 35);
                }
            } else {
                BlockPos down = pos.m_7495_();
                if (world.m_8055_(down).m_60734_() == this) {
                    world.m_7731_(down, Blocks.f_50016_.m_49966_(), 35);
                }
            }
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }
}

