/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.block;

import net.magicvt.extravagantdelight.block.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class QuinceSaplingBlock
extends Block
implements BonemealableBlock {
    private static final VoxelShape SAPLING_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);

    public QuinceSaplingBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61447_, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61447_});
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockState blockBelow = world.m_8055_(pos.m_7495_());
        return blockBelow.m_204336_(BlockTags.f_144274_);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN && !state.m_60710_((LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!world.m_5776_() && random.m_188503_(8) == 0) {
            this.growTree(world, pos, random);
        }
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        this.growTree(world, pos, random);
    }

    public boolean growTree(ServerLevel world, BlockPos pos, RandomSource random) {
        world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        int height = 2 + random.m_188503_(3);
        for (int y = 0; y < height; ++y) {
            BlockPos logPos = pos.m_6630_(y);
            world.m_7731_(logPos, ((Block)ModBlocks.QUINCE_LOG.get()).m_49966_(), 3);
        }
        Direction branchDir = Direction.Plane.HORIZONTAL.m_235690_(random);
        BlockPos branchStart = pos.m_6630_(height - 1);
        int branchLength = 1 + random.m_188503_(2);
        BlockPos branchPos = branchStart;
        for (int i = 0; i < branchLength; ++i) {
            branchPos = branchPos.m_5484_(branchDir, 1);
            world.m_7731_(branchPos, ((Block)ModBlocks.QUINCE_LOG.get()).m_49966_(), 3);
        }
        this.placeLeavesCluster(world, pos.m_6630_(height - 1), random);
        this.placeLeavesCluster(world, branchPos, random);
        return true;
    }

    private void placeLeavesCluster(ServerLevel world, BlockPos center, RandomSource random) {
        BlockState blockToPlace;
        for (BlockPos leafPos : BlockPos.m_121940_((BlockPos)center.m_7918_(-1, -1, -1), (BlockPos)center.m_7918_(1, 1, 1))) {
            if (world.m_8055_(leafPos).m_60734_() == ModBlocks.QUINCE_LOG.get()) continue;
            float chance = 0.7f;
            if (Math.abs(leafPos.m_123341_() - center.m_123341_()) == 1 && Math.abs(leafPos.m_123343_() - center.m_123343_()) == 1) {
                chance = 0.3f;
            }
            if (!(random.m_188501_() < chance)) continue;
            if (random.m_188501_() < 0.15f) {
                blockToPlace = ((Block)ModBlocks.FLOURISHING_QUINCE_LEAVES.get()).m_49966_();
                if (blockToPlace.m_61138_((Property)BlockStateProperties.f_61362_)) {
                    blockToPlace = (BlockState)blockToPlace.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
                }
            } else {
                blockToPlace = ((Block)ModBlocks.QUINCE_LEAVES.get()).m_49966_();
                if (blockToPlace.m_61138_((Property)BlockStateProperties.f_61362_)) {
                    blockToPlace = (BlockState)blockToPlace.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
                }
            }
            world.m_7731_(leafPos, blockToPlace, 3);
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos sideLeafPos = center.m_121945_(dir);
            if (!world.m_46859_(sideLeafPos) || !(random.m_188501_() < 0.5f)) continue;
            blockToPlace = ((Block)ModBlocks.QUINCE_LEAVES.get()).m_49966_();
            if (blockToPlace.m_61138_((Property)BlockStateProperties.f_61362_)) {
                blockToPlace = (BlockState)blockToPlace.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
            }
            world.m_7731_(sideLeafPos, blockToPlace, 3);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SAPLING_SHAPE;
    }
}

