/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.compat;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.magicvt.extravagantdelight.core.registry.block.ModBlocks;
import net.magicvt.extravagantdelight.recipe.StompingVatRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class StompingVatCategory
implements IRecipeCategory<StompingVatRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("extravagantdelight", "stomping_vat");
    public static final RecipeType<StompingVatRecipe> JEI_TYPE = new RecipeType(UID, StompingVatRecipe.class);
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private static final ResourceLocation INGREDIENTS_TEXTURE = new ResourceLocation("extravagantdelight", "textures/gui/jei/ingredients_bg.png");
    private static final ResourceLocation RESULT_TEXTURE = new ResourceLocation("extravagantdelight", "textures/gui/jei/result.png");

    public StompingVatCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.STOMPING_VAT.get()));
        ResourceLocation furnaceTexture = new ResourceLocation("minecraft", "textures/gui/container/furnace.png");
        this.arrow = guiHelper.drawableBuilder(furnaceTexture, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<StompingVatRecipe> getRecipeType() {
        return JEI_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.extravagantdelight.stomping_vat");
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 120;
    }

    public int getHeight() {
        return 60;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, StompingVatRecipe recipe, IFocusGroup focuses) {
        int startX = 10;
        int startY = 10;
        int cols = 2;
        for (int i = 0; i < recipe.m_7527_().size(); ++i) {
            int x = startX + i % cols * 18;
            int y = startY + i / cols * 18;
            builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients((Ingredient)recipe.m_7527_().get(i));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 90, 18).addItemStack(recipe.m_8043_(null));
    }

    public void draw(StompingVatRecipe recipe, IRecipeSlotsView slots, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        ItemStack[] matching;
        guiGraphics.m_280163_(INGREDIENTS_TEXTURE, 8, 8, 0.0f, 0.0f, 40, 40, 40, 40);
        int arrowX = 50;
        int arrowY = 18;
        if (!recipe.getRequiredItem().m_43947_() && (matching = recipe.getRequiredItem().m_43908_()).length > 0) {
            ItemStack requiredStack = matching[0].m_41777_();
            int itemX = arrowX + 4;
            int itemY = arrowY - 20;
            guiGraphics.m_280480_(requiredStack, itemX, itemY);
            guiGraphics.m_280370_(Minecraft.m_91087_().f_91062_, requiredStack, itemX, itemY);
            if (mouseX >= (double)itemX && mouseX <= (double)(itemX + 16) && mouseY >= (double)itemY && mouseY <= (double)(itemY + 16)) {
                guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237110_((String)"jei.extravagantdelight.stomping_vat.requires", (Object[])new Object[]{requiredStack.m_41786_()}), (int)mouseX, (int)mouseY);
            }
        }
        this.arrow.draw(guiGraphics, arrowX, arrowY);
        if (mouseX >= (double)arrowX && mouseX <= (double)(arrowX + 24) && mouseY >= (double)arrowY && mouseY <= (double)(arrowY + 17)) {
            guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"jei.extravagantdelight.stomping_vat.time"), (int)mouseX, (int)mouseY);
        }
        int resultX = 90;
        int resultY = 18;
        guiGraphics.m_280163_(RESULT_TEXTURE, resultX - 1, resultY - 1, 0.0f, 0.0f, 20, 20, 20, 20);
        ItemStack result = recipe.m_8043_(null);
        if (!result.m_41619_()) {
            guiGraphics.m_280480_(result, resultX, resultY);
            guiGraphics.m_280370_(Minecraft.m_91087_().f_91062_, result, resultX, resultY);
            if (mouseX >= (double)resultX && mouseX <= (double)(resultX + 16) && mouseY >= (double)resultY && mouseY <= (double)(resultY + 16)) {
                guiGraphics.m_280153_(Minecraft.m_91087_().f_91062_, result, (int)mouseX, (int)mouseY);
            }
        }
    }
}

