/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.core.registry.block;

import net.magicvt.extravagantdelight.core.registry.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HopsCropBlock
extends Block
implements BonemealableBlock {
    public static final int MAX_AGE = 7;
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)7);
    public static final IntegerProperty HEIGHT = IntegerProperty.m_61631_((String)"height", (int)1, (int)3);
    protected static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0)};

    public HopsCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)HEIGHT, (Comparable)Integer.valueOf(1)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, HEIGHT});
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int age;
        if ((Integer)state.m_61143_((Property)HEIGHT) == 1 && (age = ((Integer)state.m_61143_((Property)AGE)).intValue()) < 7 && random.m_188503_(25) == 0) {
            this.grow(world, pos, age + 1);
        }
    }

    private void grow(ServerLevel world, BlockPos pos, int newAge) {
        BlockState topState;
        BlockPos topPos;
        BlockState midState;
        BlockPos midPos;
        BlockState state = world.m_8055_(pos);
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(newAge)));
        if (newAge >= 2 && (Integer)state.m_61143_((Property)HEIGHT) == 1) {
            midPos = pos.m_7494_();
            midState = world.m_8055_(midPos);
            if (!(midState.m_60734_() instanceof HopsCropBlock) || (Integer)midState.m_61143_((Property)HEIGHT) != 2) {
                world.m_46597_(midPos, (BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(newAge))).m_61124_((Property)HEIGHT, (Comparable)Integer.valueOf(2)));
            } else {
                world.m_46597_(midPos, (BlockState)midState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(newAge)));
            }
        }
        if (newAge < 2 && (Integer)state.m_61143_((Property)HEIGHT) == 1 && (midState = world.m_8055_(midPos = pos.m_7494_())).m_60734_() instanceof HopsCropBlock && (Integer)midState.m_61143_((Property)HEIGHT) == 2) {
            world.m_7471_(midPos, false);
        }
        if (newAge >= 5 && (Integer)state.m_61143_((Property)HEIGHT) == 1) {
            topPos = pos.m_6630_(2);
            topState = world.m_8055_(topPos);
            if (!(topState.m_60734_() instanceof HopsCropBlock) || (Integer)topState.m_61143_((Property)HEIGHT) != 3) {
                world.m_46597_(topPos, (BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(newAge))).m_61124_((Property)HEIGHT, (Comparable)Integer.valueOf(3)));
            } else {
                world.m_46597_(topPos, (BlockState)topState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(newAge)));
            }
        }
        if (newAge < 5 && (Integer)state.m_61143_((Property)HEIGHT) == 1 && (topState = world.m_8055_(topPos = pos.m_6630_(2))).m_60734_() instanceof HopsCropBlock && (Integer)topState.m_61143_((Property)HEIGHT) == 3) {
            world.m_7471_(topPos, false);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        if ((Integer)state.m_61143_((Property)HEIGHT) == 1) {
            BlockState soil = world.m_8055_(pos.m_7495_());
            return soil.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("extravagantdelight", "plantable_on_farmland")));
        }
        if ((Integer)state.m_61143_((Property)HEIGHT) == 2) {
            BlockState belowState = world.m_8055_(pos.m_7495_());
            return belowState.m_60734_() instanceof HopsCropBlock && (Integer)belowState.m_61143_((Property)HEIGHT) == 1;
        }
        BlockState belowState = world.m_8055_(pos.m_7495_());
        return belowState.m_60734_() instanceof HopsCropBlock && (Integer)belowState.m_61143_((Property)HEIGHT) == 2;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!world.f_46443_ && !this.m_7898_(state, (LevelReader)world, pos)) {
            BlockPos topPos;
            BlockState topState;
            world.m_46961_(pos, false);
            if ((Integer)state.m_61143_((Property)HEIGHT) == 1) {
                BlockPos topPos2;
                BlockState topState2;
                BlockPos midPos = pos.m_7494_();
                BlockState midState = world.m_8055_(midPos);
                if (midState.m_60734_() instanceof HopsCropBlock && (Integer)midState.m_61143_((Property)HEIGHT) == 2) {
                    world.m_46961_(midPos, false);
                }
                if ((topState2 = world.m_8055_(topPos2 = pos.m_6630_(2))).m_60734_() instanceof HopsCropBlock && (Integer)topState2.m_61143_((Property)HEIGHT) == 3) {
                    world.m_46961_(topPos2, false);
                }
            } else if ((Integer)state.m_61143_((Property)HEIGHT) == 2 && (topState = world.m_8055_(topPos = pos.m_7494_())).m_60734_() instanceof HopsCropBlock && (Integer)topState.m_61143_((Property)HEIGHT) == 3) {
                world.m_46961_(topPos, false);
            }
        }
        super.m_6861_(state, world, pos, block, fromPos, isMoving);
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.m_61143_((Property)AGE) < 7;
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        int newAge = Math.min((Integer)state.m_61143_((Property)AGE) + 1 + random.m_188503_(2), 7);
        if ((Integer)state.m_61143_((Property)HEIGHT) > 1) {
            BlockPos basePos = pos;
            while (basePos.m_123342_() > world.m_141937_() && world.m_8055_(basePos.m_7495_()).m_60734_() instanceof HopsCropBlock) {
                basePos = basePos.m_7495_();
            }
            BlockState baseState = world.m_8055_(basePos);
            if (baseState.m_60734_() instanceof HopsCropBlock && (Integer)baseState.m_61143_((Property)HEIGHT) == 1) {
                this.grow(world, basePos, newAge);
            }
        } else {
            this.grow(world, pos, newAge);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_) {
            BlockPos basePos = pos;
            if ((Integer)state.m_61143_((Property)HEIGHT) == 2) {
                basePos = pos.m_7495_();
            } else if ((Integer)state.m_61143_((Property)HEIGHT) == 3) {
                basePos = pos.m_6625_(2);
            }
            BlockState baseState = world.m_8055_(basePos);
            if (baseState.m_60734_() instanceof HopsCropBlock && (Integer)baseState.m_61143_((Property)HEIGHT) == 1 && (Integer)baseState.m_61143_((Property)AGE) == 7) {
                int amount = 2 + world.f_46441_.m_188503_(3);
                ItemStack drop = new ItemStack((ItemLike)ModItems.HOPS.get(), amount);
                HopsCropBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)drop);
                this.grow((ServerLevel)world, basePos, 5);
                world.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!world.f_46443_ && state.m_60734_() != newState.m_60734_()) {
            BlockPos basePos = pos;
            if ((Integer)state.m_61143_((Property)HEIGHT) == 2) {
                basePos = pos.m_7495_();
            } else if ((Integer)state.m_61143_((Property)HEIGHT) == 3) {
                basePos = pos.m_6625_(2);
            }
            BlockState baseState = world.m_8055_(basePos);
            if (baseState.m_60734_() instanceof HopsCropBlock && (Integer)baseState.m_61143_((Property)HEIGHT) == 1) {
                BlockPos topPos;
                BlockState topState;
                world.m_46597_(basePos, Blocks.f_50016_.m_49966_());
                BlockPos midPos = basePos.m_7494_();
                BlockState midState = world.m_8055_(midPos);
                if (midState.m_60734_() instanceof HopsCropBlock && (Integer)midState.m_61143_((Property)HEIGHT) == 2) {
                    world.m_46597_(midPos, Blocks.f_50016_.m_49966_());
                }
                if ((topState = world.m_8055_(topPos = basePos.m_6630_(2))).m_60734_() instanceof HopsCropBlock && (Integer)topState.m_61143_((Property)HEIGHT) == 3) {
                    world.m_46597_(topPos, Blocks.f_50016_.m_49966_());
                }
            }
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity, ItemStack tool) {
        super.m_6240_(world, player, pos, state, blockEntity, tool);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)AGE)];
    }
}

