/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.core.registry.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.magicvt.extravagantdelight.core.registry.block.entity.ModBlockEntities;
import net.magicvt.extravagantdelight.recipe.ModRecipes;
import net.magicvt.extravagantdelight.recipe.StompingVatInventory;
import net.magicvt.extravagantdelight.recipe.StompingVatRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class StompingVatBlockEntity
extends BlockEntity {
    private final List<ItemStack> items = new ArrayList<ItemStack>();
    private ItemStack result = ItemStack.f_41583_;
    private int standTicks = 0;
    private static final int REQUIRED_TICKS = 200;
    private final ItemStackHandler itemHandler = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            StompingVatBlockEntity.this.m_6596_();
            StompingVatBlockEntity.this.items.clear();
            for (int i = 0; i < this.getSlots(); ++i) {
                ItemStack stack = this.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                ItemStack single = stack.m_41777_();
                single.m_41764_(1);
                StompingVatBlockEntity.this.items.add(single);
            }
            if (StompingVatBlockEntity.this.f_58857_ != null && !((StompingVatBlockEntity)StompingVatBlockEntity.this).f_58857_.f_46443_) {
                StompingVatBlockEntity.this.f_58857_.m_7260_(StompingVatBlockEntity.this.f_58858_, StompingVatBlockEntity.this.m_58900_(), StompingVatBlockEntity.this.m_58900_(), 3);
            }
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return true;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private final LazyOptional<IItemHandler> inputOptional = LazyOptional.of(() -> this.itemHandler);
    private final ItemStackHandler resultHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            StompingVatBlockEntity.this.m_6596_();
            StompingVatBlockEntity.this.result = this.getStackInSlot(0).m_41777_();
        }
    };
    private final LazyOptional<IItemHandler> outputOptional = LazyOptional.of(() -> this.resultHandler);

    public StompingVatBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.STOMPING_VAT.get(), pos, state);
    }

    public boolean addItem(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        if (this.items.size() >= 4) {
            return false;
        }
        ItemStack single = stack.m_41620_(1);
        this.itemHandler.insertItem(this.items.size(), single.m_41777_(), false);
        return true;
    }

    public ItemStack extractItem(Player player) {
        if (!this.result.m_41619_()) {
            ItemStack toReturn = this.result.m_41777_();
            this.result = ItemStack.f_41583_;
            this.resultHandler.setStackInSlot(0, ItemStack.f_41583_);
            this.m_6596_();
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            }
            if (!player.m_150109_().m_36054_(toReturn)) {
                player.m_36176_(toReturn, false);
            }
            return toReturn;
        }
        if (!this.items.isEmpty()) {
            int lastSlot = this.items.size() - 1;
            ItemStack removed = this.items.remove(lastSlot);
            this.itemHandler.setStackInSlot(lastSlot, ItemStack.f_41583_);
            this.m_6596_();
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            }
            if (!player.m_150109_().m_36054_(removed.m_41777_())) {
                player.m_36176_(removed.m_41777_(), false);
            }
            return removed.m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public void tickServer() {
        boolean hopperBelow;
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if (this.items.isEmpty()) {
            this.standTicks = 0;
            return;
        }
        Optional<StompingVatRecipe> recipeOpt = this.getMatchingRecipe();
        if (recipeOpt.isEmpty()) {
            this.standTicks = 0;
            return;
        }
        StompingVatRecipe recipe = recipeOpt.get();
        List players = server.m_45976_(Player.class, new AABB(this.f_58858_).m_82377_(0.5, 1.0, 0.5));
        boolean canProcess = false;
        boolean croucher = players.stream().anyMatch(p -> {
            if (!p.m_6047_()) {
                return false;
            }
            if (!recipe.getRequiredItem().m_43947_()) {
                ItemStack main = p.m_21205_();
                ItemStack off = p.m_21206_();
                if (!recipe.getRequiredItem().test(main) && !recipe.getRequiredItem().test(off)) {
                    return false;
                }
            }
            return true;
        });
        if (croucher) {
            canProcess = true;
        }
        if ((hopperBelow = this.f_58857_.m_7702_(this.f_58858_.m_7495_()) instanceof HopperBlockEntity) && (recipe.getRequiredItem().m_43947_() || this.hasRequiredItemInSideHopper(recipe))) {
            canProcess = true;
        }
        if (!canProcess) {
            this.standTicks = 0;
            return;
        }
        ++this.standTicks;
        if (this.standTicks % 20 == 0) {
            server.m_5594_(null, this.f_58858_, SoundEvents.f_11969_, SoundSource.BLOCKS, 1.0f, 1.0f);
            Block particleBlock = (Block)BuiltInRegistries.f_256975_.m_7745_(recipe.getParticleBlock());
            if (particleBlock != null && particleBlock != Blocks.f_50016_) {
                server.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, particleBlock.m_49966_()), (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.0625, (double)this.f_58858_.m_123343_() + 0.5, 10, 0.25, 0.25, 0.25, 0.02);
            }
        }
        if (this.standTicks >= 200) {
            Block block;
            ItemStack remainder;
            ItemStack output = recipe.assemble(new StompingVatInventory(this.items), server.m_9598_());
            ArrayList<ItemStack> preserved = new ArrayList<ItemStack>();
            for (ItemStack itemStack : this.items) {
                if (!itemStack.m_204117_(Tags.Items.GLASS)) continue;
                preserved.add(itemStack.m_41777_());
            }
            this.items.clear();
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
            }
            for (ItemStack itemStack : preserved) {
                this.addItem(itemStack);
            }
            if (!recipe.getRequiredItem().m_43947_()) {
                boolean consumed = false;
                for (Player p2 : players) {
                    if (!p2.m_6047_()) continue;
                    ItemStack main = p2.m_21205_();
                    ItemStack off = p2.m_21206_();
                    if (recipe.getRequiredItem().test(main)) {
                        main.m_41774_(1);
                        consumed = true;
                        break;
                    }
                    if (!recipe.getRequiredItem().test(off)) continue;
                    off.m_41774_(1);
                    consumed = true;
                    break;
                }
                if (!consumed && hopperBelow) {
                    this.consumeFromSideHopper(recipe);
                }
            }
            if (!(remainder = this.resultHandler.insertItem(0, output, false)).m_41619_()) {
                Containers.m_18992_((Level)server, (double)((double)this.f_58858_.m_123341_() + 0.5), (double)((double)this.f_58858_.m_123342_() + 1.0), (double)((double)this.f_58858_.m_123343_() + 0.5), (ItemStack)remainder);
            }
            if ((block = (Block)BuiltInRegistries.f_256975_.m_7745_(recipe.getParticleBlock())) != null && block != Blocks.f_50016_) {
                server.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block.m_49966_()), (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.0625, (double)this.f_58858_.m_123343_() + 0.5, 20, 0.25, 0.25, 0.25, 0.05);
            }
            server.m_5594_(null, this.f_58858_, SoundEvents.f_11772_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.standTicks = 0;
            this.result = this.resultHandler.getStackInSlot(0).m_41777_();
            this.m_6596_();
            server.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private boolean hasRequiredItemInSideHopper(StompingVatRecipe recipe) {
        for (Direction dir : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            BlockEntity be = this.f_58857_.m_7702_(this.f_58858_.m_121945_(dir));
            if (!(be instanceof Container)) continue;
            Container container = (Container)be;
            for (int i = 0; i < container.m_6643_(); ++i) {
                if (!recipe.getRequiredItem().test(container.m_8020_(i))) continue;
                return true;
            }
        }
        return false;
    }

    private void consumeFromSideHopper(StompingVatRecipe recipe) {
        for (Direction dir : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            BlockEntity be = this.f_58857_.m_7702_(this.f_58858_.m_121945_(dir));
            if (!(be instanceof Container)) continue;
            Container container = (Container)be;
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack = container.m_8020_(i);
                if (!recipe.getRequiredItem().test(stack)) continue;
                stack.m_41774_(1);
                container.m_6836_(i, stack);
                return;
            }
        }
    }

    private Optional<StompingVatRecipe> getMatchingRecipe() {
        if (this.f_58857_ == null || this.items.isEmpty()) {
            return Optional.empty();
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipes.STOMPING_VAT_TYPE.get(), (Container)new StompingVatInventory(this.items), this.f_58857_);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items.clear();
        ListTag list = tag.m_128437_("Items", 10);
        for (int i = 0; i < list.size(); ++i) {
            this.items.add(ItemStack.m_41712_((CompoundTag)list.m_128728_(i)));
        }
        this.standTicks = tag.m_128451_("StandTicks");
        this.result = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Result"));
        this.resultHandler.setStackInSlot(0, this.result.m_41777_());
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag list = new ListTag();
        for (ItemStack s : this.items) {
            CompoundTag it = new CompoundTag();
            s.m_41739_(it);
            list.add((Object)it);
        }
        tag.m_128365_("Items", (Tag)list);
        tag.m_128405_("StandTicks", this.standTicks);
        tag.m_128365_("Result", (Tag)this.result.m_41739_(new CompoundTag()));
    }

    public CompoundTag m_5995_() {
        CompoundTag t = super.m_5995_();
        this.m_183515_(t);
        return t;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            Direction facing;
            if (side == Direction.UP) {
                return this.inputOptional.cast();
            }
            BlockState state = this.m_58900_();
            if (state.m_61138_((Property)HorizontalDirectionalBlock.f_54117_) && side == (facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_()) {
                return this.inputOptional.cast();
            }
            if (side == Direction.DOWN) {
                return this.outputOptional.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.inputOptional.invalidate();
        this.outputOptional.invalidate();
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public int getStandTicks() {
        return this.standTicks;
    }

    public ItemStack getResult() {
        return this.result;
    }
}

