/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.core.registry.entity;

import net.magicvt.extravagantdelight.core.registry.entity.ModEntities;
import net.magicvt.extravagantdelight.core.registry.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class GrapefruitEntity
extends Entity {
    private static final EntityDataAccessor<Integer> DAMAGE = SynchedEntityData.m_135353_(GrapefruitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int ticksSinceSpawn = 0;

    public GrapefruitEntity(EntityType<? extends GrapefruitEntity> type, Level world) {
        super(type, world);
    }

    public static GrapefruitEntity create(Level world, double x, double y, double z) {
        GrapefruitEntity entity = new GrapefruitEntity((EntityType<? extends GrapefruitEntity>)((EntityType)ModEntities.GRAPEFRUIT.get()), world);
        entity.m_6034_(x, y, z);
        return entity;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DAMAGE, (Object)0);
    }

    protected void m_7378_(CompoundTag compound) {
        this.f_19804_.m_135381_(DAMAGE, (Object)compound.m_128451_("Damage"));
        this.ticksSinceSpawn = compound.m_128451_("SpawnTicks");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Damage", ((Integer)this.f_19804_.m_135370_(DAMAGE)).intValue());
        compound.m_128405_("SpawnTicks", this.ticksSinceSpawn);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.ticksSinceSpawn;
        this.m_20256_(this.m_20184_().m_82520_(0.0, -0.05, 0.0));
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (!this.m_9236_().f_46443_) {
            this.checkCollisions();
        }
    }

    private boolean isOnGround() {
        BlockPos pos = this.m_20183_();
        BlockState belowState = this.m_9236_().m_8055_(pos.m_7495_());
        if (!belowState.m_60795_() && !belowState.m_60812_((BlockGetter)this.m_9236_(), pos.m_7495_()).m_83281_()) {
            return this.m_20186_() - (double)pos.m_123342_() < 0.1;
        }
        return false;
    }

    private void checkCollisions() {
        if (this.ticksSinceSpawn < 10) {
            return;
        }
        if (this.isOnGround() || this.f_19862_) {
            this.onImpact();
            return;
        }
        Vec3 position = this.m_20182_();
        AABB boundingBox = this.m_20191_().m_82400_(0.2);
        for (Entity entity : this.m_9236_().m_45933_((Entity)this, boundingBox)) {
            if (entity == this || entity instanceof ItemEntity || entity instanceof GrapefruitEntity || entity instanceof AbstractArrow) continue;
            entity.m_6469_(this.m_269291_().m_268989_(), 2.0f);
            this.onImpact();
            break;
        }
    }

    private void onImpact() {
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_144238_, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.m_19998_((ItemLike)ModItems.GRAPEFRUIT.get());
        this.m_146870_();
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }
}

