/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.world.feature;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.magicvt.extravagantdelight.core.registry.block.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class GrapefruitTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public GrapefruitTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.m_159774_();
        BlockPos pos = context.m_159777_();
        RandomSource random = context.m_225041_();
        if (!world.m_8055_(pos.m_7495_()).m_280296_()) {
            return false;
        }
        this.generateTree((LevelAccessor)world, pos, random);
        return true;
    }

    private void generateTree(LevelAccessor world, BlockPos pos, RandomSource random) {
        world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        List<BlockPos> basePositions = List.of(pos, pos.m_122029_(), pos.m_122019_(), pos.m_122019_().m_122029_());
        for (BlockPos basePos : basePositions) {
            world.m_7731_(basePos, ((Block)ModBlocks.GRAPEFRUIT_WOOD.get()).m_49966_(), 3);
        }
        int trunkHeight = 6 + random.m_188503_(3);
        BlockPos currentPos = pos.m_7494_();
        for (int y = 0; y < trunkHeight; ++y) {
            int dx;
            world.m_7731_(currentPos, ((Block)ModBlocks.GRAPEFRUIT_LOG.get()).m_49966_(), 3);
            if (y > 2 && random.m_188501_() < 0.25f) {
                this.generateBranch(world, currentPos, random);
            }
            if (random.m_188501_() < 0.15f) {
                dx = random.m_188499_() ? 1 : -1;
                int dz = random.m_188499_() ? 1 : -1;
                currentPos = currentPos.m_7918_(dx, 1, dz);
                continue;
            }
            if (random.m_188501_() < 0.15f) {
                dx = random.m_188499_() ? 1 : -1;
                currentPos = currentPos.m_7918_(dx, 1, 0);
                continue;
            }
            if (random.m_188501_() < 0.15f) {
                int dz = random.m_188499_() ? 1 : -1;
                currentPos = currentPos.m_7918_(0, 1, dz);
                continue;
            }
            currentPos = currentPos.m_7494_();
        }
        BlockPos canopyStart = currentPos.m_7949_();
        int crownHeight = 3 + random.m_188503_(2);
        ArrayList<BlockPos> leafPositions = new ArrayList<BlockPos>();
        this.generateMinimalCanopy(world, canopyStart.m_6630_(crownHeight - 1), leafPositions);
        for (int y = 0; y < crownHeight; ++y) {
            int radiusZ;
            int radiusX;
            if (y == 0) {
                radiusX = 5;
                radiusZ = 3;
            } else if (y >= crownHeight - 2) {
                radiusX = 4;
                radiusZ = 3;
            } else {
                radiusX = 7 + random.m_188503_(4);
                radiusZ = 4 + random.m_188503_(4);
            }
            radiusZ -= y / 3;
            for (int x = -(radiusX -= y / 2); x <= radiusX; ++x) {
                for (int z = -radiusZ; z <= radiusZ; ++z) {
                    float chance;
                    double distance = Math.sqrt(Math.pow((double)x * 1.0 / (double)radiusX, 2.0) + Math.pow((double)z * 1.0 / (double)radiusZ, 2.0) + random.m_188500_() * 0.07);
                    float f = y > 0 ? (y < crownHeight - 2 ? 0.9f : 0.85f) : (chance = 1.0f);
                    if (!(distance <= 1.0) || !(random.m_188501_() < chance)) continue;
                    BlockPos leafPos = canopyStart.m_7918_(x, y, z);
                    BlockState below = world.m_8055_(leafPos.m_7495_());
                    if (!world.m_8055_(leafPos).m_60795_() || y != 0 && !below.m_60713_((Block)ModBlocks.GRAPEFRUIT_LOG.get()) && !below.m_60713_((Block)ModBlocks.GRAPEFRUIT_LEAVES.get())) continue;
                    world.m_7731_(leafPos, ((Block)ModBlocks.GRAPEFRUIT_LEAVES.get()).m_49966_(), 3);
                    leafPositions.add(leafPos);
                }
            }
        }
        if (leafPositions.size() <= 10) {
            this.extendMinimalCanopy(world, canopyStart.m_6630_(crownHeight - 1), leafPositions);
        }
    }

    private void generateBranch(LevelAccessor world, BlockPos trunkPos, RandomSource random) {
        Direction dir = null;
        for (Direction testDir : Direction.Plane.HORIZONTAL) {
            if (!world.m_8055_(trunkPos.m_121945_(testDir)).m_60795_()) continue;
            dir = testDir;
            break;
        }
        if (dir == null) {
            return;
        }
        BlockPos branchPos = trunkPos.m_121945_(dir);
        int length = 2 + random.m_188503_(2);
        for (int i = 0; i < length; ++i) {
            if (world.m_8055_(branchPos).m_60795_()) {
                world.m_7731_(branchPos, (BlockState)((Block)ModBlocks.GRAPEFRUIT_LOG.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)dir.m_122434_()), 3);
            }
            branchPos = branchPos.m_121945_(dir);
        }
    }

    private void generateMinimalCanopy(LevelAccessor world, BlockPos center, List<BlockPos> leafPositions) {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                BlockPos leafPos = center.m_7918_(x, 0, z);
                if (!world.m_8055_(leafPos).m_60795_()) continue;
                world.m_7731_(leafPos, ((Block)ModBlocks.GRAPEFRUIT_LEAVES.get()).m_49966_(), 3);
                leafPositions.add(leafPos);
            }
        }
    }

    private void extendMinimalCanopy(LevelAccessor world, BlockPos center, List<BlockPos> leafPositions) {
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                BlockPos leafPos;
                double dist = Math.sqrt(x * x + z * z);
                if (dist > 3.5 || !world.m_8055_(leafPos = center.m_7918_(x, 0, z)).m_60795_()) continue;
                world.m_7731_(leafPos, ((Block)ModBlocks.GRAPEFRUIT_LEAVES.get()).m_49966_(), 3);
                leafPositions.add(leafPos);
            }
        }
    }
}

