/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.compat;

import java.util.ArrayList;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.magicvt.extravagantdelight.core.registry.block.ModBlocks;
import net.magicvt.extravagantdelight.recipe.SorbetMakerRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SorbetMakerCategory
implements IRecipeCategory<SorbetMakerRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("extravagantdelight", "sorbet_maker");
    public static final RecipeType<SorbetMakerRecipe> JEI_TYPE = new RecipeType(UID, SorbetMakerRecipe.class);
    private final IDrawable icon;
    private final IDrawable arrow;
    private final IDrawable slotDrawable;

    public SorbetMakerCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)ModBlocks.SORBET_MAKER.get()));
        ResourceLocation furnaceTexture = new ResourceLocation("minecraft", "textures/gui/container/furnace.png");
        this.arrow = guiHelper.drawableBuilder(furnaceTexture, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.slotDrawable = guiHelper.getSlotDrawable();
    }

    public RecipeType<SorbetMakerRecipe> getRecipeType() {
        return JEI_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.extravagantdelight.sorbet_maker");
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 150;
    }

    public int getHeight() {
        return 60;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SorbetMakerRecipe recipe, IFocusGroup focuses) {
        NonNullList<SorbetMakerRecipe.CountedIngredient> cis = recipe.getCountedIngredients();
        for (int i = 0; i < cis.size(); ++i) {
            SorbetMakerRecipe.CountedIngredient ci = (SorbetMakerRecipe.CountedIngredient)cis.get(i);
            ArrayList<ItemStack> showStacks = new ArrayList<ItemStack>();
            for (ItemStack base : ci.ingredient.m_43908_()) {
                ItemStack copy = base.m_41777_();
                copy.m_41764_(ci.count);
                showStacks.add(copy);
            }
            int x = 10 + i % 3 * 18;
            int y = 10 + i / 3 * 18;
            builder.addSlot(RecipeIngredientRole.INPUT, x, y).addItemStacks(showStacks);
        }
        if (!recipe.getContainer().m_43947_()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 70, 18).addIngredients(recipe.getContainer());
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 120, 18).addItemStack(recipe.m_8043_(null));
    }

    public void draw(SorbetMakerRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        NonNullList<SorbetMakerRecipe.CountedIngredient> cis = recipe.getCountedIngredients();
        for (int i = 0; i < cis.size(); ++i) {
            int x = 10 + i % 3 * 18;
            int y = 10 + i / 3 * 18;
            this.slotDrawable.draw(guiGraphics, x, y);
            int count = ((SorbetMakerRecipe.CountedIngredient)cis.get((int)i)).count;
            if (count <= 1) continue;
            String text = String.valueOf(count);
            int textWidth = Minecraft.m_91087_().f_91062_.m_92895_(text);
            guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, text, x + 16 - textWidth, y + 16 - 8, 0xFFFFFF, false);
        }
        this.slotDrawable.draw(guiGraphics, 70, 18);
        this.slotDrawable.draw(guiGraphics, 120, 18);
        this.arrow.draw(guiGraphics, 90, 18);
    }
}

